#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "APump.h"

#include "Metaclass.h"
#include "APump_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_APump";
static	char*	class_type = "APump";

	// to initialise in_vector, out_vector and their types
void	APump::initialise()
{
	DEBUG << "void APump::initialise()\n";
	int in_terms = 1;
	int out_terms = 2;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Temperature(30);		//degC

	the_in_vector_type[0] = TemperaturE;

	the_out_vector_type[0] = TemperaturE;
	the_out_vector_type[1] = MasS;
}

APump::APump(Metaclass* meta, APump_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "APump::APump(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
void	APump::create_me(EKSObject* caller)
{
	DEBUG << "APump::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float t_i = (*the_in_vector[0]).value();

	float m_i = (*the_parameters[0]).value();

	float t_o = t_i + 2;

		// encode the result to outputs
	the_out_vector[0] = new Temperature(t_o);
	the_out_vector[1] = new Mass_flow_rate(m_i);

}
