/*
    Generic type: Printer
    Type	: Plant system output device
    Description	: data displayer, n parameters,
		  printer displays anything passed to it by AConnection.
    Note	: - to save space, Printer has no parameter and out-vector (0 sized).
		  - maximum 20 variables in in-vector can be displayed.
		  - To be consistent, the definition of APrinter is kept the same as
		    other Acomponents.
*/

#ifndef APRINTER_H
#define APRINTER_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class APrinter_def;

class APrinter : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	APrinter(Metaclass* meta, APrinter_def* def);
	~APrinter();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
