#include "APrinter.h"
#include "Metaclass.h"
#include "APrinter_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

#define Max_outputs 20		// initialise the in_vector size to 20 entries.

APrinter::APrinter(Metaclass* meta, APrinter_def* def) : (meta, (AComponent_def*)def)
{
	DEBUG << "APrinter::APrinter(" << meta->oid() << ", " << def->oid() << ")\n";


	Mixed_vector	a_vector(Max_outputs);
	the_in_vector_type = (Variable_type*)malloc(Max_outputs*sizeof(Variable_type));

	for (int i=0; i<Max_outputs; i++) {
		a_vector[i] = new Dimension(-999.99);
		the_in_vector_type[i] = GeneraL;
	}

	the_in_vector = a_vector;
};

APrinter::~APrinter()
{
	DEBUG << "APrinter::~APrinter()\n";
};

void	APrinter::create_me(EKSObject* caller)
{
	DEBUG << "APrinter::create_me(EKSObject* caller)\n";

	for (int i=0; i<Max_outputs; i++)
		if(*(the_in_vector[i]) != -999.99) {
			cout <<"print[" <<i <<"]: " << *(the_in_vector[i]) <<"\n";
		}
};

