#include 	"AConnection.h"
#include 	"AComponent.h"

#include	"Metaclass.h"
#include	"EKS.h"
#include 	"Dimension.h"
#include 	"Temperature.h"
#include 	"Energy.h"
#include 	"Mixed_vector.h"

AConnection::AConnection(Metaclass* meta, AConnection_def* def)
			: Connection(meta, (Connection_def*) def)
{ 
	DEBUG << "\nAConnection::AConnection(" <<meta->oid() <<", " <<def->oid() << ")\n";

	the_no_of_links = def->no_of_links();
	the_link_src_loc = def->link_pos_src();
	the_link_tgt_loc = def->link_pos_tgt();

#ifdef DEBUG

#endif DEBUG
};

AConnection::~AConnection()
{ 
	DEBUG << "AConnection::~AConnection()\n";

	delete the_link_src_loc;
	delete the_link_tgt_loc;
};

AConnection& AConnection::operator=(AConnection& conns)
{
	DEBUG << "AConnection::operator=(" << conns.oid() << ")\n";

	if(this==&conns) return (*this);

	(void) Connection::operator=((Connection&) conns);

	the_no_of_links = conns.the_no_of_links;
	for(int i=0; i<the_no_of_links; i++) {
		the_link_src_loc[i] = conns.the_link_src_loc[i];
		the_link_tgt_loc[i] = conns.the_link_tgt_loc[i];
	}
	return (*this);
}

void	AConnection::update_target()
{
	DEBUG << "AConnection::update_target()\n";

	AComponent*	src = (AComponent*)source();
	AComponent*	tgt = (AComponent*)target();
	Mixed_vector&	src_vec = src->out_vector();
	Variable_type*	src_type = src->out_vector_type();
	Mixed_vector&	tgt_vec = tgt->in_vector();
	Variable_type*	tgt_type = tgt->in_vector_type();

/*
		for type checking: only the same type can be passed.
		only type "GeneraL" can take anything.
*/
	for(int i=0; i<the_no_of_links; i++) {
		int isrc = the_link_src_loc[i];
		int itgt = the_link_tgt_loc[i];
		if(src_type[isrc] == tgt_type[itgt] || tgt_type[itgt] == GeneraL) {
			*(tgt_vec[itgt]) = *(src_vec[isrc]);
		} else {
			cerr <<"AConnection::update_target(): \n"
			     <<"attempt to update <" <<target_name() 
			     <<"> using inconsistent types\n";
		}
	}
};

//connect the two components.
void	AConnection::connect()
{ 
	DEBUG << "AConnection::connect()\n";

	((AComponent*)source())->create_me(this);
	update_target();
	((AComponent*)target())->create_me(this);
};
