#ifndef ACOMPONENT_H
#define ACOMPONENT_H

#include "Component.h"
#include "AComponent_def.h"
#include "Mixed_vector.h"

class AComponent : public Component {
protected:
	Mixed_vector	the_in_vector;
	Mixed_vector	the_out_vector;
	Variable_type*	the_in_vector_type;
	Variable_type*	the_out_vector_type;

public:
	AComponent(Metaclass* meta, AComponent_def* def);
	~AComponent();

	int 		no_in_nodes();
	int 		no_out_nodes();
	Mixed_vector&	out_vector();
	Variable_type*	out_vector_type();
	Mixed_vector&	in_vector();
	Variable_type*	in_vector_type();
virtual	void		create_me(EKSObject* caller);
};

inline	int 		AComponent::no_in_nodes()
{
	return	the_in_vector.size();
};

inline	int 		AComponent::no_out_nodes()
{
	return	the_out_vector.size();
};

inline	Mixed_vector&	AComponent::out_vector()
{
	return the_out_vector;
};

inline	Variable_type*	AComponent::out_vector_type()
{
	return the_out_vector_type;
};

inline	Mixed_vector&	AComponent::in_vector()
{
	return the_in_vector;
};

inline	Variable_type*	AComponent::in_vector_type()
{
	return the_in_vector_type;
};

#endif
