#ifndef ABOILER_DEF_H
#define ABOILER_DEF_H

#include "AComponent_def.h"
#include "Component.h"

#include "Mixed_vector.h"

/*
	The Boiler:

	1 parameters to be input at run time:
		0) water specific heat (j/kgk)
*/

class ABoiler_def : public AComponent_def {
protected:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
public:
	ABoiler_def(Metaclass* meta);
	ABoiler_def();
	~ABoiler_def();

	Mixed_vector&	parameters();
	Variable_type*	parameter_types();
static	void	description(Metaclass* meta, ostream& s);
};

inline Mixed_vector&	ABoiler_def::parameters()
{
	return the_parameters;
};

inline Variable_type*	ABoiler_def::parameter_types()
{
	return the_parameter_types;
};

#endif
