/*
  The Boiler: Steady state boiler

  Inputs	- 3
  Outputs	- 2
  Parameters	- 1
  Derivatives	- 0

  the_in_vector			verbal			     connection type
	[0] Wi		fuel supply energy 	 (w)		EnergY
	[1] Ti		water inlet temperature  (degC)		TmeperaturE
	[2] Mi		water mass flow rate     (kg/s)		MasS

  the_out_vector		verbal			     connection type
	[0] To 		water outlet temperature (degC)		TmeperaturE
	[1] Mo		water mass flow rate     (kg/s)		MasS

  the_parameters		verbal				connection type
	[0] Cp		specific heat of water	   (j/kg k)	GeneraL
*/

#ifndef ABOILER_H
#define ABOILER_H

#include "Mixed_vector.h"
#include "AComponent.h"
class Metaclass;
class ABoiler_def;

class ABoiler : public AComponent {
private:
	Mixed_vector	the_parameters;
	Variable_type*	the_parameter_types;
	void		initialise();
public:
	ABoiler(Metaclass* meta, ABoiler_def* def);
	~ABoiler();
/*
	int		no_in_nodes();
	int		no_out_nodes();
virtual	Mixed_vector&	out_vector();
virtual	Variable_type*	out_vector_type();
virtual	Mixed_vector&	in_vector();
virtual	Variable_type*	in_vector_type();
*/
virtual	void		create_me(EKSObject* caller);
};

#endif
