#define		MAX(x,y) ( ((x)>(y))?(x):(y) )
#define		MIN(x,y) ( ((x)<(y))?(x):(y) )

#include "ABoiler.h"

#include "Metaclass.h"
#include "ABoiler_def.h"
#include "math.h"
#include "Temperature.h"
#include "Mass_flow_rate.h"
#include "Energy.h"
#include "NonDimensional.h"

static	char*	class_name = "the_ABoiler";
static	char*	class_type = "ABoiler";

	// to initialise in_vector, out_vector and their types
void	ABoiler::initialise()
{
	DEBUG << "void ABoiler::initialise()\n";
	int in_terms = 3;
	int out_terms = 2;

	Mixed_vector in(in_terms);
	Mixed_vector out(out_terms);
	the_in_vector_type = (Variable_type*)malloc(in_terms*sizeof(Variable_type));
	the_out_vector_type = (Variable_type*)malloc(out_terms*sizeof(Variable_type));
	the_in_vector = in;
	the_out_vector = out;

	the_in_vector[0] = new Energy(20);		//w
	the_in_vector[1] = new Temperature(30);		//degC
	the_in_vector[2] = new Mass_flow_rate(1.0);	//kg/s

	the_in_vector_type[0] = EnergY;
	the_in_vector_type[1] = TemperaturE;
	the_in_vector_type[2] = MasS;

	the_out_vector_type[0] = TemperaturE;
	the_out_vector_type[1] = MasS;
}

ABoiler::ABoiler(Metaclass* meta, ABoiler_def* def) : (meta, (AComponent_def*)def), the_parameters()
{
	DEBUG << "ABoiler::ABoiler(" << meta->oid() << ", " << def->oid() << ")\n";

	char*	throwaway = class_name;

	name(def->unique_name());	//use unique_name
/**/	my_type = class_type;

	the_parameters = def->parameters();
	the_parameter_types = def->parameter_types();

	initialise();
}

	//main function to calculate the outputs from inputs and parameters.
void	ABoiler::create_me(EKSObject* caller)
{
	DEBUG << "ABoiler::create_me(EKSObject* caller)\n";

		// decode from inputs and parameters
	float w_i = (*the_in_vector[0]).value();
	float t_i = (*the_in_vector[1]).value();
	float m_i = (*the_in_vector[2]).value();

	float cpw = (*the_parameters[0]).value();

	float t_o = w_i/m_i/cpw + t_i;

		// encode the result to outputs
	the_out_vector[0] = new Temperature(t_o);
	the_out_vector[1] = new Mass_flow_rate(m_i);

}
