#include "System.h"

#include	<string.h>
#include	"System_def.h"
#include	"Metaclass.h"
#include	"Component.h"
#include	"Connection.h"
#include	"Connection_def.h"
#include	"Component_def.h"
template_define(List,Component);
template_define(List,Connection);
template_define(List,Component_def);
template_define(List,Connection_def);
//#define template_define2(Network,Connection,Component);
#include	"Time.h"

static	char*	class_name = "the_system";
/**/static	char*	class_type = "System";

Component*	System::findnode(char* component_name)
{
	Network_iterator(Component) cmp_iter = system.node_iterator();
	Component* node;
	while (node = cmp_iter(FORWARD))
		if (!strcmp(node->name(), component_name))
			return node;

	cerr << "System::findnode(char*): node for " << component_name << " not found\n";
	return NULLPTR(Component);
}

System::System(Metaclass* meta, System_def* def) : (meta), system()
{
	DEBUG	<< "System::System(" << meta->oid() << ", " << def->oid() << ")\n";

	char* throwaway = class_name;

	name(def->name());
/**/	my_type = class_type;

		// make the components add to system.
	List_iterator(Component_def) cmp_index = def->component_def_iter();
        Component_def* component_def;
	char**	cls_name = def->actual_name();

	int i=0;
        while(component_def = cmp_index(FORWARD)) {
		component_def->caller(this);
		DEBUG <<"\nmake an object for "<<cls_name[i]<<"\n";
		Component* cmp = (Component*)metaclass->make_a(cls_name[i++], component_def);
		system.add_node(cmp);
	};
		// make the connections
	List_iterator(Connection_def) conn_index = def->connection_def_iter();
        Connection_def* connection_def;
        while(connection_def = (Connection_def*)conn_index(FORWARD)) {
		connection_def->caller(this);
		Connection* connection = (Connection*)metaclass->make_a("Connection", connection_def);
		Component* src = findnode(connection->source_name());
		Component* tgt = findnode(connection->target_name());
		system.add_arc(connection, src, tgt);
		connection->assign_source(src);
		connection->assign_target(tgt);
	};
};

System::~System()
{
	DEBUG << "System::~System()\n";

	Network_iterator(Component) cmp_iter = system.node_iterator();
	Component* node;
	while (node = cmp_iter(FORWARD))
		delete node;

	Network_iterator(Connection) conn_iter = system.arc_iterator();
	Connection* arc;

	while (arc = (Connection*)conn_iter(FORWARD))
		delete arc;
};

		//all components.
List(Component)&	System::components()
{
	DEBUG << "List(Component)&	System::components()\n";

	return system.nodes();
};

		//all connections.
List(Connection)&	System::connections()
{
	DEBUG << "List(Connection)&	System::connections()\n";

	return system.arcs();
};

		//all in arcs for component cmp.
List(Connection)&	System::in_connection_for(Component* cmp)
{
	DEBUG << "List(Connection)&  System::in_connection_for(Component* cmp)\n";

	Network_iterator(Connection)	all = system.arc_iterator(cmp);
	List(Connection)& 	in_conns = *new List(Connection)();
	Connection* 		a_connection;

	while(a_connection = all(FORWARD))
		if(system.arc_target(a_connection) == cmp)
			in_conns.append(a_connection);
	
	return in_conns;
};

		//all out arcs for component cmp.
List(Connection)&	System::out_connection_for(Component* cmp)
{
	DEBUG << "List(Connection)&  System::out_connection_for(Component* cmp)\n";

	Network_iterator(Connection)	all = system.arc_iterator(cmp);
	List(Connection)&	out_conns = *new List(Connection)();
	Connection* 		a_connection;

	while(a_connection = all(FORWARD))
		if(system.arc_source(a_connection) == cmp)
			out_conns.append(a_connection);
	
	return out_conns;
};

		//nodes coming in.
List(Component)&	System::up_stream_node_for(Component* cmp) //anti flow direction.
{
	DEBUG << "List(Component)&  System::up_stream_node_for(Component* cmp)\n";

	List(Component) 		all = system.neighbours(cmp);
	List_iterator(Component) 	all_index(&all);
	List(Component)&		in_cmps = *new List(Component)();
	Component* 		a_component;

	while(a_component = all_index(FORWARD)) {
		Connection* arc = system.connection(a_component, cmp);
		if(system.arc_target(arc) == cmp)
			in_cmps.append(a_component);
	}
	
	return in_cmps;
}

		//nodes in the down stream.
List(Component)&	System::down_stream_node_for(Component* cmp)	//flow direction.
{
	DEBUG << "List(Component)&  System::down_stream_node_for(Component* cmp)\n";

	List(Component) 		all = system.neighbours(cmp);
	List_iterator(Component) 	all_index(&all);
	List(Component)&		out_cmps = *new List(Component)();
	Component* 		a_component;

	while(a_component = all_index(FORWARD)) {
		Connection* arc = system.connection(a_component, cmp);
		if(system.arc_source(arc) == cmp)
			out_cmps.append(a_component);
	}
	
	return out_cmps;
}

void	System::execute()
{
	DEBUG << "void	System::execute()\n";

	cout << "\ndisplay names of nodes and arcs.\n";

	List(Component)&  lp = components();
	List(Connection)& ln = connections();
	List_iterator(Component) comps(&lp);
	List_iterator(Connection) cons(&ln);

	int i=1;
	Component* comp;
	while (comp = comps(FORWARD))
		cout << "Component " << i++ << " : " << comp->name() << "\n";

	i=1;
	Connection* con;
	while (con = cons(FORWARD)) {
		cout << "Connection " << i++ << " : " << con->name() << " : "
			<< con->source_name() << " -> " << con->target_name() << "\n";
	}
};

template_implement(List,Component);
template_implement(List,Connection);
template_implement2(Network,Connection,Component);
