#include 	"Connection.h"
#include	"Connection_def.h"

#include	"Metaclass.h"
#include	"EKS.h"

static	char*	class_name = "the_connection";
static	char*	class_type = "Connection";

Connection::Connection(Metaclass* meta, Connection_def* def)
			: EKSObject(meta)
{ 
	DEBUG << "Connection::Connection(" << meta->oid() << ", " << def->oid() << ")\n";

	char* throwaway = class_name;	//use unique name.

	name(def->unique_name());
	my_type = class_type;

		//initialise.
	the_source = NULLPTR(Component);
	the_target = NULLPTR(Component);

	the_source_name = def->source_name();
	the_target_name = def->target_name();
};

Connection::~Connection()
{ 
	DEBUG << "Connection::~Connection()\n";
};

Connection& Connection::operator=(Connection& conns)
{
	DEBUG1 << "Connection::operator=(" << conns->oid() << ")\n";

	if(this==&conns) return (*this);

	the_source = conns.the_source;
	the_target = conns.the_target;
	the_source_name = conns.the_source_name;
	the_target_name = conns.the_target_name;
	return (*this);
};

void	Connection::assign_source(Component* src)
{
	the_source = src;
};

void	Connection::assign_target(Component* tgt)
{
	the_target = tgt;
};
