#ifndef GRAPH_H
#define GRAPH_H

#include	"EKSObject.h"
#include	"network.h"
template_define2(Network,Graph_arc,Graph_node);
class	Metaclass;

class Graph : public EKSObject {
private:
	Network(Graph_arc,Graph_node)	the_graph;

public:
	Graph(Metaclass* meta);
	~Graph();

	List(Graph_node)&	nodes();
	List(Graph_artc)&	arcs();

		// basic operations.
	add_arc(Graph_arc* an_arc, Graph_node* src_node, Graph_node* des_node);
	add_node(Graph_node* a_node);
	remove_arc(Graph_arc* an_arc);
	remove_node(Graph_node* a_node);
	get_source();
	get_destination();
	get_depth(Graph_node* a_node);
	print_graph();

		//determines a Matching for graph
	match_graph();

		//finds strongly connected components of graph
	strong_component();

		//creates reduced graph based on strongly connected components
	reduced_graph();

		//determines a small Cut Set for graph
	cut_set();

		//Performs a topological sort of graph
	topologic_sort();
	

};
#endif
