#include	"Graph.h"

Graph::Graph(Metaclass* meta): EKSObject(meta), the_graph()
{
	DEBUG	<< "Graph::Graph(" << meta->oid() << ", ";

	List_iterator(Room_def)& rm_index = def->room_def_iter();
        Room_def* room_def;
        while(room_def = rm_index(FORWARD)) {
				// add contiguity pointer to x_def
		room_def->contiguity(&contiguity);
		Room* room = (Room*)metaclass->make_a("Room", room_def);
		contiguity.add_node(room);
	};
	delete  &rm_index;
			// make the constructions
	List_iterator(Construction_def)& rmlnk_index = def->construction_def_iter();
        Construction_def* construction_def;
        while(construction_def = rmlnk_index(FORWARD)) {
				// add contiguity pointer to x_def
		construction_def->contiguity(&contiguity);
		Construction* construction = (Construction*)metaclass->make_a("Construction", construction_def);
		Room* right_room = findzone(construction_def->right_zone_name());
		Room* left_room = findzone(construction_def->left_zone_name());
		contiguity.add_arc(construction, right_room, left_room);
	};
	delete  &rmlnk_index;
	
};

Graph::~Graph()
{
	DEBUG << "Graph::~Building()\n";

	Network_iterator(Room)& rm_iter = contiguity.node_iterator();
	Room* node;
	while (node = rm_iter(FORWARD))
		delete node;
	delete &rm_iter;

	Network_iterator(Construction)& rmlnk_iter = contiguity.arc_iterator();
	Construction* arc;
	while (arc = rmlnk_iter(FORWARD))
		delete arc;
	delete &rmlnk_iter;
};


List(Room)&	Graph::rooms()
{
	return contiguity.nodes();
};

List(Construction)&	Graph::constructions()
{
	return contiguity.arcs();
};

List(Construction)&	Graph::constructions_for(Room* rm)
{
	return contiguity.connections(rm);
};


template_implement(List,Construction);
template_implement2(Network,Graph_arc,Graph_node);
