#include "Type010_flow.h"
#include "Type010_flow_def.h"

#include "Flow_node.h"
#include "Metaclass.h"
#include "Substance.h"
#include "EKS.h"
#include <math.h>

static	char*	class_name = "the_type010_flow";
static	char*	class_type = "Type010_flow";

Type010_flow::Type010_flow(Metaclass* meta, Type010_flow_def* def) :
					Flow_arc(meta, (Flow_arc_def*) def)
{
	DEBUG << "Type010_flow::Type010_flow(" << meta->oid() << ", " << def->oid() << ")\n";

	char* hideaway = class_name;

	name(def->unique_name());	//use unique_name in Connection_def
	my_type = class_type;

	FCOF = def->coefficient();
	FEXP = def->exponent();
};

Type010_flow::~Type010_flow()
{
	DEBUG << "Type010_flow::~Type010_flow()\n";
};

Type010_flow& Type010_flow::operator=(Type010_flow& a)
{
	DEBUG1 << "Type010_flow& Type010_flow::operator=(" << a->oid() << ")\n";

	if(this==&a) return (*this);

	(void) Flow_arc::operator=((Flow_arc&) a);

	FCOF = a.FCOF;
	FEXP = a.FEXP;
	return (*this);
}

	/* This function calculates flow rate and put into the protected data
	   of its parent class.
	   This function has to be called before use flow1, flow2.
	*/
void Type010_flow::arc_flow()
{ // MF010C: power law volume flow resistance (m = rho.a.dP^b)

	re_set();

	flow2 = 0;
	float DELP = (float&)(dp_current);
	float RHON = rho.value();
	if(DELP > 0)
		flow1.setValue(pow(RHON*FCOF*DELP, FEXP));
			// function of class Dimension.
	else
		flow1.setValue(-pow(RHON*FCOF*fabs(DELP), FEXP));
}

	/* This function can only be called after arc_flow().
	*/
float Type010_flow::arc_flow_derivative()
{
	float SMALL = 1.0E-20;
	float DELP = dp_current.value();
	float flw = flow1.value();
	float DERIV;
	if(DELP > SMALL) {
		DERIV = FEXP*flw/DELP;
		//derivative_previous = DERIV; not in the original.
		//flow_previous = flow1+flow2;
	} else
		DERIV = numerical_derivative();

	return DERIV;
}

Mass_flow_rate Type010_flow::get_flow1()
{
	return flow1;
}

Mass_flow_rate Type010_flow::get_flow2()
{
	return flow2;
}

int Type010_flow::get_flow_type()
{
	return 10;	// flow type 10.
}

	// Re-set data for new time step.
void Type010_flow::re_set()
{
	Dimension p1 = get_from_node()->get_current_pressure();
	Dimension p2 = get_to_node()->get_current_pressure();
	dp_current = p2 -p1+stack;
	p1 = get_from_node()->get_previous_pressure();
	p2 = get_to_node()->get_previous_pressure();
	dp_previous = p2 - p1;
	rho = sub->density();
}
