#ifndef FLOW_NODE_DEF_H
#define FLOW_NODE_DEF_H

#include "Component_def.h"
#include "Pressure.h"
#include "Temperature.h"

class Flow_node_def : public Component_def {
protected:
	int		the_node_number;
	int		the_node_type;
	Pressure	the_node_pressure;
	Temperature	the_node_temperature;
public:
	Flow_node_def(Metaclass* meta);
	Flow_node_def();
	~Flow_node_def();

	int		node_number();
	int		node_type();
	Pressure	node_pressure();
	Temperature	node_temperature();

static	void	description(Metaclass* meta, ostream& s);
};

#endif

inline int	Flow_node_def::node_number()
{
	return the_node_number;
};

inline int	Flow_node_def::node_type()
{
	return the_node_type;
};
inline Pressure	Flow_node_def::node_pressure()
{
	return the_node_pressure;
};
inline Temperature	Flow_node_def::node_temperature()
{
	return the_node_temperature;
};
