#ifndef FLOW_NODE_H
#define FLOW_NODE_H

#include "Component.h"
#include "Flow_node_def.h"

#include "Pressure.h"
#include "Length.h"
#include "Mass_flow_rate.h"
#include "Temperature.h"

// #include "util_eks.h"

class Metaclass;
class Pressure;
class Temperature;
class Length;
class Mass_flow_rate;

class Flow_node : public Component {
protected:
	int 		the_node_number;
	int 		the_node_type;  //0,1,2,3.
	Pressure	the_p_current;
	Temperature	the_node_temp;
	Pressure 	the_p_previous;
	Pressure 	the_p_correction;
	Pressure 	the_p_correction_previous;
	Mass_flow_rate	the_flow_residual;
	Mass_flow_rate	the_flow_coupled_sum;
	float		the_relax;
public:
	friend class Flow_network;
	Flow_node(Metaclass* meta, Flow_node_def* def);
	~Flow_node();
//	Flow_node(Flow_node& n);
	Flow_node& operator=(Flow_node& n);

	void	 	set_p_correction(Pressure p);
	void	 	set_p_correction_previous(Pressure p);
	void 		set_temperature(Temperature t);
	void 		set_flow_residual(Mass_flow_rate f);
	void 		set_flow_coupled_sum(Mass_flow_rate c);
	void		update_pressure(Pressure p);
	void		set_relax(float r);
	int		node_number();
	int		node_type();
	Pressure 	get_p_correction();
	Pressure 	get_p_correction_previous();
	Temperature	get_temperature();
	Mass_flow_rate	get_flow_residual();
	Mass_flow_rate	get_flow_coupled_sum();
	Pressure 	get_current_pressure();
	Pressure 	get_previous_pressure();
	float		get_relax();
};

#endif
