#include "Flow_node.h"
#include "Metaclass.h"

static	char*	class_name = "the_flow_node";
static	char*	class_type = "Flow_node";

Flow_node::Flow_node(Metaclass* meta, Flow_node_def* def) :
						Component(meta, (Component_def*)def)
{
	DEBUG << "Flow_node::Flow_node(" << meta->oid() << ", " << def->oid() << ")\n";

	char* hideaway = class_name;

	name(def->unique_name());	//use unique_name in Component_def
	my_type = class_type;

	the_node_number = def->node_number();
	the_node_type = def->node_type();
	the_p_current = def->node_pressure();
	the_node_temp = def->node_temperature();
	the_p_previous = 0;
	the_p_correction = 0;
	the_p_correction_previous = 0;
	the_flow_residual = 0;
	the_flow_coupled_sum = 0;
	the_relax = 0;
};

Flow_node::~Flow_node()
{
	DEBUG << "Flow_node::~Flow_node()\n";
};

Flow_node& Flow_node::operator=(Flow_node& n)
{
	if(this==&n) return *this;
	the_node_number = n.the_node_number;
	the_node_type = n.the_node_type;
	the_p_current = n.the_p_current;
	the_p_previous = n.the_p_previous;
	the_p_correction = n.the_p_correction;
	the_node_temp = n.the_node_temp;
	the_flow_residual = n.the_flow_residual;
	the_flow_coupled_sum = n.the_flow_coupled_sum;
	return *this;
}

void Flow_node::set_p_correction(Pressure p)
{
	the_p_correction = p;
}

void Flow_node::set_p_correction_previous(Pressure p)
{
	the_p_correction_previous = p;
}

void Flow_node::set_temperature(Temperature t)
{
	the_node_temp = t;
}

void Flow_node::set_flow_residual(Mass_flow_rate f)
{
	the_flow_residual = f;
}

void Flow_node::set_flow_coupled_sum(Mass_flow_rate c)
{
	the_flow_coupled_sum = c;
}

void Flow_node::update_pressure(Pressure p)
{
	the_p_previous = the_p_current;
	the_p_current = p;
}

void Flow_node::set_relax(float r)
{
	the_relax = r;
}

int Flow_node::node_number()
{
	return the_node_number;
}

int Flow_node::node_type()
{
	return the_node_type;
}

Pressure Flow_node::get_p_correction()
{
	return the_p_correction;
}

Pressure Flow_node::get_p_correction_previous()
{
	return the_p_correction_previous;
}

Temperature Flow_node::get_temperature()
{
	return the_node_temp;
}

Mass_flow_rate Flow_node::get_flow_residual()
{
	return the_flow_residual;
}

Mass_flow_rate Flow_node::get_flow_coupled_sum()
{
	return the_flow_coupled_sum;
}

Pressure Flow_node::get_current_pressure()
{
	return the_p_current;
}

Pressure Flow_node::get_previous_pressure()
{
	return the_p_previous;
}

float Flow_node::get_relax()
{
	return the_relax;
}
