#ifndef FLOW_NETWORK_DEF_H
#define FLOW_NETWORK_DEF_H

#include	"System_def.h"
#include	"list.h"

class Metaclass;
class Flow_arc_def;
class Flow_node_def;

template_declare(List,Flow_node_def)
template_declare(List,Flow_arc_def)

class Flow_network_def : public System_def {
protected:
	float	the_relative_error;
	float	the_absolute_error;
	int	the_max_steps;
	float	the_max_p_correction;
	float	the_correction_bound;
	int 	the_solver_type;
public:
	Flow_network_def(Metaclass* meta);
	Flow_network_def(char* a_name, List(Flow_node_def)* cmps, List(Flow_arc_def)* conns);
	~Flow_network_def();

	float	relative_error();
	float	absolute_error();
	int	max_steps();
	float	max_p_correction();
	float	correction_bound();
	int 	solver_type();

static  void    description(Metaclass* meta, ostream& s);
};

#endif

inline float	Flow_network_def::relative_error()
{
	return the_relative_error;
};

inline float	Flow_network_def::absolute_error()
{
	return the_absolute_error;
};

inline int	Flow_network_def::max_steps()
{
	return the_max_steps;
};

inline float	Flow_network_def::max_p_correction()
{
	return the_max_p_correction;
};

inline float	Flow_network_def::correction_bound()
{
	return the_correction_bound;
};

inline int	Flow_network_def::solver_type()
{
	return the_solver_type;
};
