#ifndef FLOW_NETWORK_H
#define FLOW_NETWORK_H

#define SMALL	1e20
#define MNOD	100

#include "System.h"
#include "Matrix.h"

class Metaclass;
class Flow_network_def;
class Flow_node;
class Flow_arc;
class Type010_flow;

template_declare(List,Component);
template_declare(List,Connection);
template_declare(List,Flow_node);
template_declare(List,Flow_arc);

class Flow_network : public System {
private:
	int 		no_of_nodes;
	int 		no_of_arcs;
	List(Flow_node)*	the_flow_node_list;
	List(Flow_arc)* 	the_flow_arc_list;

	int 		ok;
	Flow_node*	the_worst_node_abs;
	Flow_node*	the_worst_node_rel;
	Matrix		jacobi;

	float 		ferrel;
	float 		fermfl;
	float 		steffr;
	float 		pmax;
	int		maxitf;
	int		mslvtp;
public:
	Flow_network(Metaclass* meta, Flow_network_def* def);
	~Flow_network();

	// Flow_network& operator=(Flow_network& net);

	void add_node(Flow_node* n);
	void add_arc(Flow_arc* a);
	List(Flow_node)*	get_node_list();
	List(Flow_arc)* 	get_arc_list();

	void initialise();
	void arc_flow();
	int worst_node(int& iter);
	void solution();
	void stefensen_optimisation();
	void set_pressure();
	void simulate();
	void report();

	void jsolvd(Matrix a, int n, float*  x, float* b);
	void ludcmp(Matrix a, int n, int* indx, float  d);
	void lubksb(Matrix a, int n, int*    x, float* b);
};

#endif
