#ifndef FLOW_ARC_H
#define FLOW_ARC_H
#ifndef DEBUG
#define DEBUG /\
/
#endif

#include "Connection.h"
#include "Mass_flow_rate.h"
#include "Pressure.h"
#include "Density.h"

class Metaclass;
class Flow_arc_def;
class Flow_node;
class Substance;

class Flow_arc : public Connection {
private:
	int 		arc_number;
	Flow_node* 	from_node;	//P1	source()
	Flow_node* 	to_node;	//P2	target()
protected:
	friend class Flow_network;
	Substance*	sub;
	Pressure	dp_current; 	//dP=P2-P1
	Pressure	dp_previous;
	Pressure	stack;
	Density		rho;
	Mass_flow_rate	flow_previous;
	Mass_flow_rate	flow1;
	Mass_flow_rate	flow2;
	float 		derivative_previous;
public:
	Flow_arc(Metaclass* meta, Flow_arc_def* def);
	~Flow_arc();
	Flow_arc& operator=(Flow_arc& a);

	Flow_node* 	get_from_node();
	Flow_node* 	get_to_node();
	int 		get_arc_number();
	Pressure	get_stack();
	float 		numerical_derivative();

virtual void 		arc_flow();
virtual float 		arc_flow_derivative();
virtual	Mass_flow_rate	get_flow1();
virtual	Mass_flow_rate	get_flow2();
};

#endif
