#include "Flow_arc.h"
#include "Flow_node.h"
#include "Metaclass.h"
#include "Flow_arc_def.h"
#include "Substance.h"
#include "EKS.h"

static	char*	class_name = "the_flow_arc";
static	char*	class_type = "Flow_arc";

Flow_arc::Flow_arc(Metaclass* meta, Flow_arc_def* def) :
				Connection(meta, (Connection_def*) def)
{
	DEBUG << "Flow_arc::Flow_arc(" << meta->oid() << ", " << def->oid() << ")\n";

	char* hideaway = class_name;

	name(def->unique_name());	//use unique_name in Connection_def
	my_type = class_type;
	
	from_node = (Flow_node*)source();
	to_node = (Flow_node*)target();
	sub = &(def->substance());
	arc_number = def->arc_number();
	stack = def->stack();

/* When created, the constructor initialises pressure differences
** and density for lts flow.
*/
	dp_current = from_node->get_current_pressure()-
		to_node->get_current_pressure();
	
	dp_previous = from_node->get_previous_pressure()-
		to_node->get_previous_pressure();
	rho = sub->density();
	derivative_previous = 0;
};

Flow_arc::~Flow_arc()
{
	DEBUG << "Flow_arc:~Flow_arc()\n";
};

Flow_arc& Flow_arc::operator=(Flow_arc& a)
{
	if(this==&a) return (*this);
	from_node = a.from_node;
	to_node = a.to_node;
	sub = a.sub;
	arc_number = a.arc_number;
	return *this;
}

Flow_node* Flow_arc::get_from_node()
{
	return from_node;
}

Flow_node* Flow_arc::get_to_node()
{
	return to_node;
}

int Flow_arc::get_arc_number()
{
	return arc_number;
}

Pressure Flow_arc::get_stack()
{
	return stack;
}

void Flow_arc::arc_flow()
{
	cout << "Flow_arc::arc_flow -\n";
	cout << "this function should not have been called.\n";
}

float Flow_arc::arc_flow_derivative()
{
	cout << "Flow_arc::arc_flow_derivative -\n";
	cout << "this function should not have been called.\n";
	return 0;
}

/* MFNPDV(ICNN,DELP,DERIV)
** Numerical calculation of partial derivative dFlw[s]/d(dPress)
** which is to be used when the partial derivative cannot be
** calculated analytically by MFxxxC.
** The partial derivative is approximated by (Fnow-Fprev)/(dPnow-dPprev)
** If the partial derivative turns out to be close to zero then the
** previous value is returned instead; this is done to avoid numerical
** problems when using the derivative in Newton-Raphson technique.
   function returns the numerical value of the partial derivative.
   This function is called only by function 'arc_flow_derivative()' in
   derived class 'Type010_flow'.
*/
float Flow_arc::numerical_derivative()
{
	float SMALL = 1.0E-20;
	float DDP = (float&)(dp_current-dp_previous);
	float deriv;
	//dp_previous = dp_current;  this line not needed.
	if(fabs((float&)(flow1+flow2-flow_previous))>SMALL && fabs(DDP)>SMALL) {
		deriv = (float&)(flow1+flow2-flow_previous)/DDP;
		derivative_previous = deriv;
	}
	else
		deriv = derivative_previous;

	flow_previous = flow1+flow2;
	return deriv;
}

