#include	"Context_3b_def.h"

#include	"Metaclass.h"
#include	"Conduction_fd_def.h"		// for debug oid()
#include	"Convection_fd_1_def.h"		// for debug oid()
#include	"Radiation_fd_1_def.h"		// for debug oid()
#include	"Solver_def.h"		// for debug oid()

static	char*	class_name = "the context_3b_def";
/**/static	char*	class_type = "Context_3b_def";


Context_3b_def::Context_3b_def(Metaclass* meta)
				: Context_domain_def(meta), Context_3a_def(meta)
{
	DEBUG	<< "Context_3b_def::Context_3b_def(" << meta->oid() << ")\n";

	name(class_name);
/**/	my_type = class_type;

	conduction = (Conduction_fd_def*)meta->make_def_for("Conduction");
	convection = (Convection_fd_1_def*)meta->make_def_for("Convection");
	radiation = (Radiation_fd_1_def*)meta->make_def_for("Radiation");
	solver = (Solver_def*)meta->make_def_for("Solver");
};

Context_3b_def::Context_3b_def(Site_sun_def* a_site_def, Building_es_def* a_bld_def,
	Conduction_fd_def* a_conduct_def, Convection_fd_1_def* a_convect_def,
	Radiation_fd_1_def* a_rad_def, Solver_def* a_solver_def)
			: Context_domain_def((Conduction_def*)a_conduct_def,
					     (Convection_def*)a_convect_def,
					     (Radiation_def*)a_rad_def, 
					     (Solver_def*)a_solver_def),
			Context_3a_def(a_site_def, (Building_def*)a_bld_def)
{
	DEBUG	<< "Context_3b_def::Context_3b_def(. . . . .)\n";

	name(class_name);
/**/	my_type = class_type;

	conduction = a_conduct_def;
	convection = a_convect_def;
	radiation = a_rad_def;
	solver = a_solver_def;
};

Context_3b_def::~Context_3b_def()
{
	DEBUG << "Context_3b_def::~Context_3b_def()\n";
};




void	Context_3b_def::description(Metaclass* meta, ostream& s)
{
	s << "->     Conduction\n";
        meta->describe_def_for("Conduction", s);
	s << "<-     Conduction\n";
	s << "->     Convection\n";
        meta->describe_def_for("Convection", s);
	s << "<-     Convection\n";
	s << "->     Radiation\n";
        meta->describe_def_for("Radiation", s);
	s << "<-     Radiation\n";
	s << "->     Solver\n";
        meta->describe_def_for("Solver", s);
	s << "<-     Solver\n";
	Context_3a_def::description(meta, s);
}
