#include	"Context_3b.h"

#include	<string.h>
#include	"Metaclass.h"
#include	"Site_sun.h"
#include	"Building_es.h"
#include	"Building_es_def.h"
#include	"Conduction_fd.h"
#include	"Conduction_fd_def.h"
#include	"Convection_fd_1.h"
#include	"Convection_fd_1_def.h"
#include	"Radiation_fd_1.h"
#include	"Radiation_fd_1_def.h"
#include	"Gauss_column_pivot.h"
#include	"Gauss_column_pivot_def.h"
#include	"Time_of_day.h"
#include	"ClimateRegime.h"
#include	"Equation_set.h"
template_define(List,Equation_set);
#include	"State_vector.h"
#include	"Vector.h"

static	char*	class_name = "the context_3b";
/**/static	char*	class_type = "Context_3b";


Context_3b::Context_3b(Metaclass* meta, Context_3b_def* def)
				: Context_domain(meta, (Context_domain_def*)def),
				  Context_3a(meta, (Context_3a_def*)def)
{
	DEBUG	<< "Context_3b::Context_3b(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
/**/	my_type = class_type;

};

Context_3b::~Context_3b()
{
	DEBUG << "Context_3a::~Context_3a()\n";
};


Building_es*	Context_3b::building()
{
				// cast guaranteed by Metaclasses
	return (Building_es*)the_building;
};

Conduction_fd*	Context_3b::conduction()
{
				// cast guaranteed by Metaclasses
	return (Conduction_fd*)Context_domain::conduction();
};

Convection_fd_1*	Context_3b::convection()
{
				// cast guaranteed by Metaclasses
	return (Convection_fd_1*)Context_domain::convection();
};

Radiation_fd_1*	Context_3b::radiation()
{
				// cast guaranteed by Metaclasses
	return (Radiation_fd_1*)Context_domain::radiation();
};

Gauss_column_pivot*	Context_3b::solver()
{
				// cast guaranteed by Metaclasses
	return (Gauss_column_pivot*)Context_domain::solver();
};

void	Context_3b::simulate()
{
	DEBUG1	<< "Context_3b::simulate()\n";
	cout << "Running program demo2 b\n\n";

	int	h, yd;
	cout << "Time (hour, yearday) ? ";
	cin >> h >> yd;
	Time_of_day t(0.0, 0, h, yd, 67);
	do {
		ClimateRegime clm_reg = site()->climateRegime(t);
		cout << "got ClimateRegime:\n"
		     << "\tTemp = " << clm_reg.temperature_dry()
		     << " degC (wet " << clm_reg.relative_humidity() << "%)\n"
		     << "\tWind " << clm_reg.wind_speed()
		     << " m/s from " << clm_reg.wind_direction() << " deg\n\n";

		building()->thermal_disc();
		DEBUG2	<< "Building discretized\n";
		building()->apply_boundary_conditions(&clm_reg);
		Equation_iterator eqn_iter = building()->equation_iterator();
		DEBUG2	<< "got Equations - here they are\n";
		Equation* eqn;
		while (eqn = eqn_iter(FORWARD))
		DEBUG2	<< "\t" << *eqn;
			;
		Vector& sv = solver()->execute(eqn_iter);
		DEBUG2	<< "got state vector - here it is\n\t" << sv << "\n";
		eqn_iter(RESET);
		while (eqn = eqn_iter(FORWARD)) {
			eqn->state_variable()->state_variable(sv[i]);
		t =+ 3600;		// hourly timestep
	}
};
