#include	"Context_3a.h"

#include	<string.h>
#include	"Metaclass.h"
#include	"Site_sun.h"
#include	"Building.h"
#include	"Building_def.h"
#include	"Construction.h"
template_define(List,Construction);
#include	"Room.h"
template_define(List,Room);
#include	"Time_of_day.h"
#include	"ClimateRegime.h"

static	char*	class_name = "the context_3a";
/**/static	char*	class_type = "Context_3a";


Context_3a::Context_3a(Metaclass* meta, Context_3a_def* def)
				: (meta, (Context_1b_def*)def)
{
	DEBUG	<< "Context_3a::Context_3a(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
/**/	my_type = class_type;
						// make Building or derived
	the_building =(Building*)metaclass->make_a("Building",def->building_def());
};

Context_3a::~Context_3a()
{
	DEBUG << "Context_3a::~Context_3a()\n";
};


Site_sun*	Context_3a::site()
{
						// cast guaranteed by Metaclass
	return	(Site_sun*) the_site;
};

void	Context_3a::simulate()
{
	DEBUG1	<< "Context_3a::simulate()\n";

	int	n = 1;
	int	i = -1;
	cout << "Running program\n\n";
	while (++i < n) {
		int h = i % 24;
		int d = i / 24;
		Time_of_day t(0.0, 0, i, d, 67);
		ClimateRegime clm_reg = site()->climateRegime(t);
		DEBUG1	<< "got 1st ClimateRegime\n";
	};
	List(Room) rms = the_building->rooms();
	List_iterator(Room) rm_iter(&rms);
	Room*	rm;
	while (rm = rm_iter(FORWARD))
		cout << "Room " << rm->name()
		     << "	volume " << rm->volume() << "\n";
	List(Construction) cns = the_building->constructions();
	List_iterator(Construction) constr_iter(&cns);
	Construction*	constr;
	while (constr = constr_iter(FORWARD)) {
		Room* rgt_z = the_building->rightRoom_for(constr);
		Room* lft_z = the_building->leftRoom_for(constr);
		cout << "Construction (between ";
		cout << (lft_z==NULLPTR(Room) ? "outside" : lft_z->name())
		     << " and " ;
		cout << (rgt_z==NULLPTR(Room) ? "outside" : rgt_z->name());
		cout << "	thickness " << constr->thickness() << "\n";
	};
	cout << "Byebye\n";
};


template_implement(List,Room);
