#include	"Context_2b.h"

#include	<string.h>
#include	"transport/Time_of_day.h"
#include	"transport/ClimateRegime.h"
#include	"transport/Equation_set.h"
template_define(List,Equation_set);
#include	"transport/Vector.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Site_basic.h"
#include	"building/Construction_es.h"
#include	"building/Construction_es_def.h"
#include	"building/Layer_es.h"
template_declare(List,Layer_es);
#include	"theory/Conduction_fd.h"
#include	"theory/Conduction_fd_def.h"
#include	"solver/Gauss_column_pivot.h"
#include	"solver/Gauss_column_pivot_def.h"

static	char*	class_name = "demo_2b";
Type*	Context_2b_Type_pointer;


Context_2b::Context_2b(Metaclass* meta, Context_2b_def* def)
				: Context_domain_c(meta, (Context_domain_c_def*)def),
				  Context_2a(meta, (Context_2a_def*)def)
{
	DEBUG	<< "Context_2b::Context_2b(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_2b));
};

Context_2b::Context_2b(APL* theAPL) : Context_2a(theAPL)
{};


void	Context_2b::simulate()
{
	DEBUG1	<< "Context_2b::simulate()\n";

	cout << "Running program demo2 b\n\n";

	int	h, yd;
	cout << "Time (hour, yearday) ? ";
	cin >> h >> yd;
	Time_of_day t(0.0, 0, h, yd, 67);
	ClimateRegime clm_reg = site()->climateRegime(t);
	cout << "got ClimateRegime:\n"
	     << "\tTemp = " << clm_reg.temperature_dry()
	     << " degC (wet " << clm_reg.relative_humidity() << "%)\n"
	     << "\tWind " << clm_reg.wind_speed()
	     << " m/s from " << clm_reg.wind_direction() << " deg\n\n";

	construction()->disc_conduction();
	DEBUG2	<< "Construction discretized\n";
	float temp;
	cout << "What is the internal temperature ? ";
	cin >> temp;
	construction()->apply_boundary_conditions(clm_reg.temperature_dry(), temp);
	Equation_iterator eqn_iter=construction()->equation_iterator();
	eqn_iter(RESET);
	DEBUG2	<< "got Equations - here they are\n";
	Equation* eqn;
	while (eqn = eqn_iter(FORWARD))
		DEBUG2	<< "\t" << *eqns;
		;
	Vector& sv = solver()->execute(eqn_iter);
	DEBUG2	<< "got state vector - here it is\n\t" << sv << "\n";

	List_iterator(Layer_es)&   lyr_iter = construction()->layer_iterator();
	Layer_es*	lyr = NULLPTR(Layer_es);
	cout << "Temperature profile\nRregion\tTemp\tLayer width\n";
	int	j = 0;
	while(lyr = lyr_iter(FORWARD)) {
		cout << "\t\t" << lyr->thickness() << " m\n";
		for (int i = 0; i < lyr->no_of_divisions(); i++)
			cout << "   " << j << ":\t" << sv[j++] << " degC\n";
	};
};
