#include	"Context_2a.h"

#include	<string.h>
#include	"dimensions/Area.h"
#include	"dimensions/Length.h"
#include	"transport/Time_of_day.h"
#include	"transport/ClimateRegime.h"
#include	"transport/Polygon.h"
#include	"infrastructure/Metaclass.h"
////#include	"site/Site_basic.h"
#include	"building/Construction_basic.h"
#include	"building/Construction_basic_def.h"
#include	"building/Surface_basic.h"

static	char*	class_name = "demo_2a";
Type*	Context_2a_Type_pointer;


Context_2a::Context_2a(Metaclass* meta, Context_2a_def* def)
				: Context_1b(meta, (Context_1b_def*)def)
{
	DEBUG	<< "Context_2a::Context_2a(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_1b));

					// make Construction or derived
	the_construction = INSTANTIATE(Construction_basic,def->construction_def());
};

Context_2a::Context_2a(APL* theAPL) : Context_1b(theAPL)
{
	DEBUG	<< "Context_2a::Context_2a(theAPL)\n";

	RETRIEVE(the_construction);
};


Context_2a::~Context_2a()
{
	Destroy(FALSE);
};


void	Context_2a::Destroy(Boolean aborted)
{
	DEBUG << "Context_2a::Destroy(" << aborted? "TRUE" : "FALSE" << ")\n";

	DELETE(Construction_basic, the_construction);

	if (aborted)
		Context_1b::Destroy(aborted);
};

void	Context_2a::putObject(Boolean deallocate)
{
	DEBUG << "Context_2a::putObject(" << deallocate? "TRUE" : "FALSE" << ")\n";

	STORE(the_construction);
};

void	Context_2a::deleteObject(Boolean deallocate)
{
	DEBUG << "Context_2a::deleteObject(" << deallocate? "TRUE" : "FALSE" << ")\n";

	FORGET(the_construction);
};


void	Context_2a::simulate()
{
	DEBUG1	<< "Context_2a::simulate()\n";

	cout << "Running program\n\n";

	int	h, yd;
	cout << "Time (hour, yearday) ? ";
	cin >> h >> yd;
	Time_of_day t(0.0, 0, h, yd, 67);
	ClimateRegime clm_reg = site()->climateRegime(t);
	cout << "got ClimateRegime:\n"
	     << "\tTemp = " << clm_reg.temperature_dry()
	     << " degC (rh " << clm_reg.relative_humidity() << "%)\n"
	     << "\tWind " << clm_reg.wind_speed()
	     << " m/s from " << clm_reg.wind_direction() << " deg\n\n";

	Length	thickness = construction()->thickness();
	Area	area = construction()->leftSurface()->polygon()->area();
	cout << "got Construction data:\n"
	     << "\tArea " << area << " m2,"
	     << "thickness " << thickness << " m\n";
};
