#include	"Context_1c.h"

					// default name for class instances
static	char*	class_name = "the context_1c";
					//for ONTOS use (via TYPE_OF macro)	
Type*	Context_1b_Type_pointer;

				// main constructor - for use by Metaclass
				//   calls base class constructor.  Contecxt_1c_def
				//   is derived from Context_1b_def, so cast ok
Context_1c::Context_1c(Metaclass* meta, Context_1c_def* def)
				: Context_1b(meta, (Context_1b_def*)def)
{
				// DEBUG facility - enable by "CC -DDEBUG=cerr ..."
	DEBUG  << "Context_1c::Context_1c(Metaclass* meta, Context_1c_def* def)\n";

				// set name of instance (here set to default)
	name(class_name);
				// for ONTOS
	directType(TYPE_OF(Context_1c));

				// create any extra data classes/members from X_def
};

				// ONTOS constructor - usually does nothing 
Context_1c::Context_1c(APL* theAPL) : Context_1b(theAPL)
{};

				// destructor
Context_1c::~Context_1c()
{
	DEBUG << "Context_1c::~Context_1c()\n";
};

void	Context_1c::simulate()
{	int	n = 0;
	int	i = -1;
	DEBUG1	<< "Context_1c::simulate()\n";

	cout << "Running program (Context_1c)\n\nHow many values do you want? ";
	cin >> n;
	while (++i < n) {
		int h = i % 24;
		int d = i / 24;
		Time_of_day t(0.0, 0, h, d, 67);
		ClimateRegime clm_rec = site()->climateRegime(t);
		cout << i << clm_rec.temperature_dry()  << ",\t"
			  << clm_rec.relative_humidity()*100  << ",\t"
			  << clm_rec.wind_speed()  << ",\t"
			  << clm_rec.wind_direction()  << "\n";
		List_iterator(Irradiance)& i_iter = clm_rec.get_iterator();
		Irradiance* ird;
		while (ird = i_iter(FORWARD))
			cout << "\t\t" << ird->direct() << ",\t"
			     << ird->diffuse() << "\n";
	};
};


Lists
	List "template" facility - C++ meaning of "template" = parameterized class

	List(char) => List of char* 

declare a list of char* as
	template_declare(List,char);
NB no spaces!!		declares class = class x;
define class as
	template_define(List,char);
once per compilation	defines class = class x {int a;  public: x() {}; };
implement class as
	template_implement(List,char);
once per program		provides methods for ctor, accessing list.

eg
	List(char)	my_list();	// create new empty list
	my_list.insert("first");	// put in at top
	char* p = my_list.first();	// returns top element
	my_list.remove(char* p);	// returns top element

iterator class provided to access elements in the list
	List_iterator(char)	iter(&my_list);	// create list iterator
	char* p = iter[2]			// 3rd element on list (expensive)
	char* p = iter(FORWARD);		// gets next element on list
						// 1st call gets 1st elem on list

eg	List_iterator(char)	iter(&my_list);
	char*	p;
	while (p = iter(FORWARD)) {
		/do something with p
	};

						// can also iter(BACKWARD) and 
						// iter(RESET) 

Similar parameterized Network class	:in Network.h
	Network(Arc,Node)	net;
NB dont also define List(Arc) in same compilation run.

	accessors eg
		List(Node) ns = net.neighbours(node2)
		List(Arc) na = net.connected_to(node2)

Also Vector and Matrix parameterized classes
	Vector(State_variables)	s_vars();


