#include	"Context_1b_r.h"

#include	<string.h>
#include	"Site_sun.h"
#include	"Time_of_day.h"
#include	"ClimateRegime.h"
#include	"Irradiance.h"

static	char*	class_name = "the context_1b_r";
/**/static	char*	class_type = "Context_1b_r";


Context_1b_r::Context_1b_r(Metaclass* meta, Context_1b_r_def* def)
				: Context_1a(meta, (Context_1a_def*)def)
{
	DEBUG	<< "Context_1b_r::Context_1b_r(Metaclass* meta, Context_1b_r_def* def)\n";

	name(class_name);
/**/	my_type = class_type;
};

Context_1b_r::~Context_1b_r()
{
	DEBUG << "Context_1b_r::~Context_1b_r()\n";
};

Site_sun*	Context_1b_r::site()
{
				// cast guaranteed by Metaclass
	return (Site_sun*)the_site;
};

void	Context_1b_r::simulate()
{       cout << "\nHello, this is class Context_1b_r !\n\n";
	int	n = 0;
	int	i = -1;
	DEBUG1	<< "Context_1b_r::simulate()\n";

	cout << "Running program\n\nHow many values do you want? ";
	cin >> n;
        cout << " Values from climate data:\n"
             << "dry. temp, rel. hum, wind speed and dir, dir. and diff. rad\n\n";
             
	while (++i < n) {
		int h = i % 24;
		int d = i / 24;
		Time_of_day t(0.0, 0, h, d, 67);
		ClimateRegime clm_rec = site()->climateRegime(t);
		cout << i << clm_rec.temperature_dry()/10  << " degC,\t"
			  << clm_rec.relative_humidity()*100  << " perc.,\t"
			  << clm_rec.wind_speed()/10  << " m/s,\t"
			  << clm_rec.wind_direction()  << " degrees\n";
		List_iterator(Irradiance)& i_iter = clm_rec.get_iterator();
		Irradiance* ird;
		while (ird = i_iter(FORWARD))
			cout << "\t\t" << ird->direct() << " W/sqm,\t"
			     << ird->diffuse() << " W/sqm\n";
	};
};
