#include	"context/Context_1b.h"

#include	<string.h>
#include	"transport/Time_of_day.h"
#include	"transport/ClimateRegime.h"
//#include	"transport/Irradiance.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Site_sun.h"

static	char*	class_name = "demo_1b";
Type*	Context_1b_Type_pointer;


Context_1b::Context_1b(Metaclass* meta, Context_1b_def* def)
				: Context_1a(meta, (Context_1a_def*)def)
{
			// DEBUG facility - enable by "CC -DDEBUG=cerr ..."
	DEBUG	<< "Context_1b::Context_1b(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_1b));
};

Context_1b::Context_1b(APL* theAPL) : Context_1a(theAPL)
{};


void	Context_1b::simulate()
{	int	n = 0;
	int	i = -1;
	DEBUG1	<< "Context_1b::simulate()\n";

	cout << "Running program\n\nHow many values do you want? ";
	cin >> n;
	while (++i < n) {
		int h = i % 24;
		int d = i / 24;
		Time_of_day t(0.0, 0, h, d, 67);
		ClimateRegime clm_rec = site()->climateRegime(t);
		cout << i << clm_rec.temperature_dry()  << ",\t"
			  << clm_rec.relative_humidity()*100  << ",\t"
			  << clm_rec.wind_speed()  << ",\t"
			  << clm_rec.wind_direction()  << "\n";
//		List_iterator(Irradiance)& i_iter = clm_rec.get_iterator();
//		Irradiance* ird;
//		while (ird = i_iter(FORWARD))
//			cout << "\t\t" << ird->direct() << ",\t"
//			     << ird->diffuse() << "\n";
	};
};
