#include	"Context_1a_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"
#include	"site/Site_basic_def.h"

static	char*	class_name = "the context_1_def";
Type*	Context_1a_def_Type_pointer;


Context_1a_def::Context_1a_def(Metaclass* meta)  : Context_def(meta)
{
	DEBUG	<< "Context_1a_def::Context_1a_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_1a_def));

	site = meta->make_def_for("Site");
};

Context_1a_def::Context_1a_def(Site_basic_def* a_site_def)  : Context_def()
{
	DEBUG	<< "Context_1a_def::Context_1a_def(" << a_site_def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_1a_def));

	site = a_site_def;
};

Context_1a_def::Context_1a_def(APL* theAPL) : Context_def(theAPL)
{};

Context_1a_def::~Context_1a_def()
{
	DEBUG << "Context_1_def::~Context_1_def()\n";
};


Site_basic_def*	Context_1a_def::site_def()
{
	DEBUG1	<< "Context_1a_def::site_def()\n";
						// cast guaranteed by Metaclass
	return (Site_basic_def*)site;
};


void	Context_1a_def::description(Metaclass* meta, ostream& s)
{
	s << "Context_1a\n";
	s << indent << "->  Site = ";
	strcat(indent,"    ");
	meta->describe_def_for("Site", s);
	indent[strlen(indent)-4] = '\0';
};
