#include	"context/Context_1a.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
#include	"transport/Time_of_day.h"
#include	"transport/ClimateRegime.h"
#include	"site/Site_basic.h"

static	char*	class_name = "demo_1a";
Type*	Context_1a_Type_pointer;


Context_1a::Context_1a(Metaclass* meta, Context_1a_def* def)
				: Context(meta, (Context_def*)def)
{
	DEBUG	<< "Context_1a::Context_1a(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Context_1a));

					// make a Site_basic or derived
	the_site = INSTANTIATE(Site_basic, def->site_def());
};

Context_1a::Context_1a(APL* theAPL) : Context(theAPL)
{
	DEBUG	<< "Context_1a::Context_1a(theAPL)\n";

	RETRIEVE(the_site);
};

Context_1a::~Context_1a()
{
	Destroy(FALSE);
};

void	Context_1a::Destroy(Boolean aborted)
{
	DEBUG << "Context_1a::Destroy(" << aborted? "TRUE" : "FALSE" << ")\n";

	DELETE(Site_basic, the_site);

	if (aborted)
		Context::Destroy(aborted);
};

void	Context_1a::putObject(Boolean deallocate)
{
	DEBUG << "Context_1a::putObject(" << deallocate? "TRUE" : "FALSE" << ")\n";

	STORE(the_site);
};

void	Context_1a::deleteObject(Boolean deallocate)
{
	DEBUG << "Context_1a::deleteObject(" << deallocate? "TRUE" : "FALSE" << ")\n";

	FORGET(the_site);
};


void	Context_1a::simulate()
{	int	n = 0;
	int	i = -1;
	DEBUG1	<< "Context_1a::simulate()\n";

	cout << "Running program\n\nHow many values do you want? ";
	cin >> n;
	while (++i < n) {
		int h = i % 24;
		int d = i / 24;
		Time_of_day t(0.0, 0, i, d, 67);
		ClimateRegime clm_reg = site()->climateRegime(t);
		cout << i << clm_reg.temperature_dry()  << ", "
			  << clm_reg.relative_humidity()*100  << ", "
			  << clm_reg.wind_speed()  << ", "
			  << clm_reg.wind_direction()  << "\n";
	};
};
