#include "Surface_es_sw.h"

#include	"Surface_es_sw_def.h"
#include	"Metaclass.h"
#include	"Polygon.h"
#include	"Conduction.h"
#include	"Radiation.h"
#include	"../demo3/Shortwave_beam.h"
template_define(List,Shortwave_beam);
#include	"Irradiance.h"
#include	"Temperature.h"
#include	"Energy.h"


static	char*	class_name = "the_surface_es_sw";
/**/static	char*	class_type = "Surface_es_sw";


Surface_es_sw::Surface_es_sw(Metaclass* meta, Surface_es_sw_def* def)
			: Surface_es(meta, (Surface_es_def*)def)
{
	DEBUG << "Surface_es_sw::Surface_es_sw(Metaclass* meta, Surface_es_sw_def* def)\n";

	name(class_name);
/**/	my_type = class_type;

					// link to Radiation or derived
	the_radiation = meta->link_to("Radiation", def->radiation_name());
};

Surface_es_sw::Surface_es_sw(Finish* fin, Polygon* poly, ThermalResistance resist, Conduction* cond, Radiation* rad)
			: Surface_es(fin, poly, resist, cond)
{
	DEBUG << "Surface_es_sw::Surface_es_sw(EKSObject* caller, Finish* fin, Polygon* poly, ThermalResistance resist)\n";

	name(class_name);
/**/	my_type = class_type;

	the_radiation = rad;
};

Surface_es_sw::Surface_es_sw(Surface_es_sw& surf)  : Surface_es((Surface_es&) surf)
{
	DEBUG << "Surface_es::Surface_es_sw(Surface_es_sw& surf)\n";

	name(class_name);
/**/	my_type = class_type;

	the_radiation = surf.the_radiation;
};

Surface_es_sw::~Surface_es_sw()
{
	DEBUG	<< "Surface_es_sw::~Surface_es_sw()\n";
};


Surface_es_sw& Surface_es_sw::operator=(Surface_es_sw& surf)
{
	DEBUG1 << "Surface_es_sw::operator=(Surface_es_sw& surf)\n";	

	if (this==&surf) return (*this);

	(void) Surface_es::operator=((Surface_es&) surf);
	the_radiation = surf.the_radiation;
 
	return (*this);
};


Radiation*	Surface_es_sw::radiation()
{
	DEBUG1	<< "Radiation*   Surface_es::radiation()\n";

	return (Radiation*)the_radiation;
};


List(Shortwave_beam)&	Surface_es_sw::apply_boundary_conditions(Shortwave_beam& incident)
{
	DEBUG1	<< "void   Surface_es_sw::apply_boundary_conditions(Shortwave_beam& incident)\n";

				// dump all incident energy into 1st layer
	Energy gain = incident.irradiance()->direct() +
						incident.irradiance()->diffuse();
	radiation()->inject_energy(*the_equation_iterator, the_state_variable, gain);
	DEBUG2	<< "got incomming shortwave";
	DEBUG2	<< "Surface_es::gain =";
	DEBUG2	<< "\t" << gain;

	List(Shortwave_beam)	reflected;
	return reflected;
};
