#ifndef SURFACE_ES_H
#define SURFACE_ES_H

#include	"transport/Equation_set.h"
#include 	"building/Surface_basic.h"
//#include 	"theory/Construction.h"
class	Surface_es_def;
class	State_variable;
class	Conduction;

extern	Type*	Surface_es_Type_pointer;


class Surface_es : public Surface_basic {
protected:
	State_variable*		the_state_variable;	// of adjacent layer
	Equation_iterator*	the_equation_iterator;	// ordered from surface
	Conduction*		the_conduction;		// = Conduction
public:
	Surface_es(Metaclass* meta, Surface_es_def* def);
	Surface_es(Finish* fin, Polygon* poly, ThermalResistance resist, Conduction* cond);
	Surface_es(Surface_es& surf);
	Surface_es(APL* theAPL);
	~Surface_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Surface_es& operator=(Surface_es& surf);

	void			state_variable(State_variable* sv);
	void			equation_iterator(Equation_iterator& eqn_iter);

	Conduction*		conduction();
	State_variable*		state_variable();
	Equation_iterator	equation_iterator();		// nb may be NULL
	void			apply_boundary_conditions(Temperature& external);
};


inline
Type*	Surface_es::getDirectType()
{
	return TYPE_OF(Surface_es);
};

#endif
