#include	"building/Surface_es.h"

#include	"dimensions/Temperature.h"
#include	"dimensions/Energy.h"
#include	"transport/Polygon.h"
#include	"infrastructure/Metaclass.h"
#include	"building/Surface_es_def.h"
#include	"theory/Conduction.h"


static	char*	class_name = "the_surface_es";
Type*	Surface_es_Type_pointer;


Surface_es::Surface_es(Metaclass* meta, Surface_es_def* def)
			: Surface_basic(meta, (Surface_basic_def*)def)
{
	DEBUG << "Surface_es::Surface_es(Metaclass* meta, Surface_es_def* def)\n";

	name(class_name);
	directType(TYPE_OF(Surface_es));

	the_equation_iterator = NULLPTR(Equation_iterator);

					// link to Conduction or derived
	the_conduction = (Conduction*)meta->link_to("Conduction",
						    def->conduction_name());
};

Surface_es::Surface_es(Finish* fin, Polygon* poly, ThermalResistance resist, Conduction* cond)
			: Surface_basic(fin, poly, resist)
{
	DEBUG << "Surface_es::Surface_es(EKSObject* caller, Finish* fin, Polygon* poly, ThermalResistance resist)\n";

	name(class_name);
	directType(TYPE_OF(Surface_es));

	the_equation_iterator = NULLPTR(Equation_iterator);
	the_conduction = cond;
};

Surface_es::Surface_es(Surface_es& surf)  : Surface_basic((Surface_basic&) surf)
{
	DEBUG << "Surface_es::Surface_es(Surface& surf)\n";

	name(class_name);
	directType(TYPE_OF(Surface_es));

	the_equation_iterator = surf.the_equation_iterator;
	the_conduction = surf.the_conduction;
};

Surface_es::Surface_es(APL* theAPL)  : Surface_basic(theAPL)
{
	RETRIEVE(the_conduction);
};

Surface_es::~Surface_es()
{
	DEBUG	<< "Surface_es::~Surface_es()\n";

	if (the_equation_iterator != NULLPTR(Equation_iterator))
		delete the_equation_iterator;

	Destroy(FALSE);
};


void	Surface_es::Destroy(Boolean aborted)
{
	DEBUG << "Surface_es::Destroy(Boolean aborted)\n";

	if (aborted)
		Surface_basic::Destroy(aborted);
};

void	Surface_es::putObject(Boolean deallocate)
{
	DEBUG << "Surface_es::putObject(Boolean deallocate)\n";

	STORE(the_conduction);

	Surface_basic::putObject(deallocate);
};

void	Surface_es::deleteObject(Boolean deallocate)
{
	DEBUG << "Surface_es::deleteObject(Boolean deallocate)\n";

	Surface_basic::deleteObject(deallocate);
};


Surface_es& Surface_es::operator=(Surface_es& surf)
{
	DEBUG1 << "Surface_es::operator=(Surface_es& surf)\n";	

	if (this==&surf) return (*this);

	(void) Surface::operator=((Surface&) surf);
	the_equation_iterator = surf.the_equation_iterator;
	the_conduction = surf.the_conduction;
 
	return (*this);
};


void	Surface_es::state_variable(State_variable* sv)
{
	DEBUG1	<< "void   Surface_es::state_variable(State_variable* sv)\n";

	the_state_variable = sv;
};

void	Surface_es::equation_iterator(Equation_iterator& eqn_iter)
{
	DEBUG1	<< "void   Surface_es::equation_iterator(Equation_iterator& eqn_iter)\n";

	the_equation_iterator = new Equation_iterator(eqn_iter);
};



Conduction*	Surface_es::conduction()
{
	DEBUG1	<< "Conduction*   Surface_es::conduction()\n";

	return (Conduction*)the_conduction;
};

State_variable*	Surface_es::state_variable()
{
	DEBUG1	<< "State_variable*   Surface_es::state_variable()\n";

	return the_state_variable;
};

Equation_iterator	Surface_es::equation_iterator()
{
	DEBUG1	<< "Equation_iterator	Surface_es::equation_iterator()\n";

	return *the_equation_iterator;
};

void	Surface_es::apply_boundary_conditions(Temperature& external)
{
	DEBUG1	<< "void   Surface_es::apply_boundary_conditions(Temperature& external)\n";

	Temperature	temp_diff = external - the_state_variable->state_variable();
	Energy gain = the_polygon->area() * temp_diff / the_surface_resistance;
	conduction()->inject_energy(*the_equation_iterator, the_state_variable, gain);
	DEBUG2	<< "got boundary condition";
	DEBUG2	<< "Surface_es::gain =";
	DEBUG2	<< "\t" << gain;
};
