#include	"building/Surface_basic_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"

static	char*	class_name = "the surface_basic_def";
Type*	Surface_basic_def_Type_pointer;


Surface_basic_def::Surface_basic_def(Metaclass* meta)  : Surface_def(meta),
					the_surface_resistance(0)
{
	DEBUG	<< "Surface_basic_def::Surface_basic_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Surface_basic_def));

	float sr;
	cout << "Surface thermal resistance? ";
	cin >> sr;
	the_surface_resistance = sr;
};

Surface_basic_def::Surface_basic_def(Finish& fin, Polygon* poly, ThermalResistance resist)
			: Surface_def(fin, poly), the_surface_resistance(resist)
{
	DEBUG	<< "Surface_basic_def::Surface_basic_def(Finish& fin, Polygon* poly, ThermalResistance resist)\n";

	name(class_name);
	directType(TYPE_OF(Surface_basic_def));
};

Surface_basic_def::Surface_basic_def(APL* theAPL) : Surface_def(theAPL)
{}

Surface_basic_def::~Surface_basic_def()
{
	DEBUG << "Surface_basic_def::~Surface_basic_def()\n";
};


ThermalResistance	Surface_basic_def::resistance()
{
	DEBUG1	<< "ThermalResistance	Surface_basic_def::resistance()\n";

	return the_surface_resistance;
};


void	Surface_basic_def::description(Metaclass* meta, ostream& s)
{
	s << "Surface_basic\n";
	s << indent << "surface finish emissivity: \n"
	  << indent << "surface finish reflectivity: \n"
	  << indent << "surface finish roughness: \n"
	  << indent << "surface polygon: \n"
	  << indent << "surface thermal resistance: \n";
};
