#ifndef SURFACE_BASIC_H
#define SURFACE_BASIC_H

/* Contains a finish pointer and a polygon pointer. */

#include	"dimensions/ThermalResistance.h"
#include 	"building/Surface.h"
class	Surface_basic_def;

extern	Type*	Surface_basic_Type_pointer;


class Surface_basic : public Surface {
protected:
	ThermalResistance  the_surface_resistance;
public:
	Surface_basic(Metaclass* meta, Surface_basic_def* def);
	Surface_basic(Finish* fin, Polygon* poly, ThermalResistance  resist);
	Surface_basic(Surface_basic& surf);
	Surface_basic(APL* theAPL);
	~Surface_basic();

	Type*	getDirectType();

	Surface_basic& operator=(Surface_basic& surf);	// deep copy of poly

	ThermalResistance	resistance();
};


inline
Type*	Surface_basic::getDirectType()
{
	return TYPE_OF(Surface_basic);
};
#endif

