#include	"building/Surface_basic.h"

#include	"building/Surface_basic_def.h"

static	char*	class_name = "the_surface_basic";
Type*	Surface_basic_Type_pointer;


Surface_basic::Surface_basic(Metaclass* meta, Surface_basic_def* def)
			: Surface(meta, (Surface_def*) def),
			  the_surface_resistance(def->resistance())
{
	DEBUG << "Surface_basic::Surface_basic(Metaclass* meta, Surface_basic_def* def)\n";

	name(class_name);
	directType(TYPE_OF(Surface_basic));
}

Surface_basic::Surface_basic(Finish* fin, Polygon* poly, ThermalResistance resist)
			: Surface(fin, poly),
			  the_surface_resistance(resist)
{
	DEBUG << "Surface_basic::Surface_basic(Finish* fin, Polygon* poly, ThermalResistance resist)\n";

	name(class_name);
	directType(TYPE_OF(Surface_basic));
};

Surface_basic::Surface_basic(Surface_basic& surf)
			: Surface((Surface&) surf),
			  the_surface_resistance(surf.the_surface_resistance)
{
	DEBUG << "Surface_basic::Surface_basic(Surface_basic& surf)\n";

	name(class_name);
	directType(TYPE_OF(Surface_basic));
}

Surface_basic::Surface_basic(APL* theAPL) : Surface(theAPL)
{}

Surface_basic::~Surface_basic()
{
	DEBUG	<< "Surface::~Surface()\n";
};


Surface_basic& Surface_basic::operator=(Surface_basic& surf)
{
	DEBUG1 << "Surface_basic::operator=(Surface_basic& surf)\n";	

	if (this==&surf) return (*this);

	(void) Surface::operator=((Surface&)surf);
        the_surface_resistance=surf.the_surface_resistance;
 
       return (*this);
}

ThermalResistance	Surface_basic::resistance()
{
	DEBUG1	<< "ThermalResistance*	Surface_basic::resistance()\n";

	return the_surface_resistance;
};

