#include	"building/Room_es_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"
#include	"building/HeatSource_def.h"		// for debug oid()

static	char*	class_name = "the room_es_def";
Type*	Room_es_def_Type_pointer;


Room_es_def::Room_es_def(Metaclass* meta)  : Room_basic_def(meta)
{
	DEBUG	<< "Room_es_def::Room_es_def(" << meta->oid() << ")\n";

					// name is space name ( from Space_def)
	directType(TYPE_OF(Room_es_def));

	char	buffer[256];
	cout << "which Conduction theory object for Room (name)? ";
	cin >> buffer;
	the_conduction_name = strdup(buffer);
	cout << "which Convection theory object for Room (name)? ";
	cin >> buffer;
	the_convection_name = strdup(buffer);
	cout << "which Radiation theory object for Room (name)? ";
	cin >> buffer;
	the_radiation_name = strdup(buffer);
};

Room_es_def::Room_es_def(Volume& vol, AirVolume_es_def* airvol,
				List(HeatSource_def)& hsourceds,
				char* a_conduction_name,
				char* a_convection_name,
				char* a_radiation_name)
			: Room_basic_def(vol, (AirVolume_def*)airvol,  hsourceds)
{
	DEBUG	<< "Room_es_def::Room_es_def(FilledVolume& filledvol, List(HeatSource_def)* a_heatSource_def)\n";

	my_name = class_name;
	directType(TYPE_OF(Construction_es_def));

	the_conduction_name = a_conduction_name;
	the_convection_name = a_convection_name;
	the_radiation_name = a_radiation_name;
};

Room_es_def::Room_es_def(APL* theAPL)  : Room_basic_def(theAPL)
{};

Room_es_def::~Room_es_def()
{
	DEBUG << "Room_es_def::~Room_es_def()\n";
};


char*		Room_es_def::conduction_name()
{
	DEBUG	<< "char::Room_es_def::conduction_name()\n";

	return the_conduction_name;
};

char*		Room_es_def::convection_name()
{
	DEBUG	<< "char::Room_es_def::convection_name()\n";

	return the_convection_name;
};

char*		Room_es_def::radiation_name()
{
	DEBUG	<< "char::Room_es_def::radiation_name()\n";

	return the_radiation_name;
};


void    Room_es_def::description(Metaclass* meta, ostream& s)
{
        Room_basic_def::description(meta, s);
	s << "conduction theory name: \n";
	s << "convection theory name: \n";
	s << "radiation theory name: \n";
};
