#ifndef ROOM_ES_H
#define ROOM_ES_H 

/* comment */

#include	"infrsatructure/list.h"
#include	"transport/Equation_set.h"
#include	"building/Room.h"
class	Room_es_def;
class	AirVolume_es;
class	Conduction;
class	Convection;
class	Radiation;
typedef	float	ViewFactor;
//???class 	ViewFactor;

extern	Type*	Room_es_Type_pointer;


class Room_es : public Room {
protected:
	Equation_set	the_equation_set;
	EKSObject*	the_conduction;
	EKSObject*	the_convection;
	EKSObject*	the_radiation;
//???	ViewFactor*	the_view_factors;	// class not yet available.
public:
        Room_es(Metaclass* meta, Room_es_def* def);
        Room_es(Room_es& rm);
        Room_es(APL* theAPL);
	~Room_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	Room_es&	operator=(Room_es& c);

	Conduction*		conduction();
	Convection*		convection();
	Radiation*		radiation();
	AirVolume_es*		airVolume();
	Equation_iterator	equation_iterator();
	Surface*		surface_for(State_variable* sv);

	ViewFactor		viewFactor(Surface* s1, Surface* s2);
	void	thermal_disc();
	void	disc_conduction();
	void	disc_convection();
	void	disc_contents();
	void	disc_longwave();
	void	disc_heatsources();

////	List(Shortwave_beam)&	shortwave_response(List(Shortwave_beam)& incident);
};


inline
Type*	Room_es::getDirectType()
{
	return TYPE_OF(Room_es);
};

inline
Conduction*	Room_es::conduction()
{                                                // cast guaranteed by Metaclass
	return (Conduction*)the_conduction;
};

inline
Convection*	Room_es::convection()
{                                               // cast guaranteed by Metaclass
	return (Convection*)the_convection;
};

inline
Radiation*	Room_es::radiation()
{                                               // cast guaranteed by Metaclass
	return (Radiation*)the_radiation;
};

inline
AirVolume_es*	Room_es::airVolume()
{                                               // cast guaranteed by Metaclass
	return (AirVolume_es*)theAirVolume;
};


inline
Equation_iterator	Room_es::equation_iterator()
{
        Equation_iterator       iter(&the_equation_set);
        return iter;                                    // list may be empty 
};

#endif

