#include	"building/Room_es.h"

#include	"infrastructure/Metaclass.h"
#include	"building/Room_es_def.h"
#include	"building/AirVolume_es.h"
#include	"building/Surface_es.h"
#include	"building/HeatSource.h"
#include	"theory/Conduction.h"
#include	"theory/Convection.h"
#include	"theory/Radiation.h"
//???#include 	"ViewFactor.h"

static	char*	class_name = "the_room_es_xxxx";
Type*	Construction_es_Type_pointer;


Room_es::Room_es(Metaclass* meta, Room_es_def* def) : Room_basic(meta, (Room_basic_def*)def)
{
	DEBUG	<< "Room_es::Room_es(" << meta->oid() << ", " << def->oid() << ")\n";

					// name is space name ( from Space_def)
	directType(TYPE_OF(Room_es));
					// link to appropriatetheory classes
	the_conduction = (Conduction*)metaclass->link_to("Conduction",
							def->conduction_name());
	the_convection = (Convection*)metaclass->link_to("Convection",
							def->convection_name());
	the_radiation = (Radiation*)metaclass->link_to("Radiation",
							def->radiation_name());
};

Room_es::Room_es(Room_es& rm)  : Room_basic((Room_basic&) rm),
				     the_equation_set(rm.the_equation_set)
{
	DEBUG << "Room_es::Room_es(" << rm->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Room_es));

	the_conduction = rm.conduction();
	the_convection = rm.convection();
	the_radiation = rm.radiation();
};

Room_es::Room_es(APL* theAPL) : Room_basic(theAPL)
{
	RETRIEVE(the_conduction);
	RETRIEVE(the_convection);
	RETRIEVE(the_radiation);
};

Room_es::~Room_es()
{
	DEBUG << "Room_es::~Room_es()\n";

	Destroy(FALSE);
};


void	Room_es::Destroy(Boolean aborted)
{
	DEBUG << "Room_es::Destroy(Boolean aborted)\n";

	if (aborted)
		Room_basic::Destroy(aborted);
};

void	Room_es::putObject(Boolean deallocate)
{
	DEBUG << "Room_es::putObject(Boolean deallocate)\n";

	STORE(the_conduction);
	STORE(the_convection);
	STORE(the_radiation);

	Room_basic::putObject(deallocate);
};

void	Room_es::deleteObject(Boolean deallocate)
{
	DEBUG << "Room_es::deleteObject(Boolean deallocate)\n";

	Room_basic::deleteObject(deallocate);
};


Room_es& Room_es::operator=(Room_es& rm)
{
	DEBUG1 << "Room_es::operator=(" << rm->oid() << ")\n";

	if(this==&rm) return (*this);

	(void) Room_basic::operator=((Room_basic&) rm);
	the_conduction = rm.conduction();
	the_convection = rm.convection();
	the_radiation = rm.radiation();
	the_equation_set = rm.the_equation_set;	// shallow copy

	return (*this);
};
 
ViewFactor	Room_es::viewFactor(Surface* s1, Surface* s2)
{
	DEBUG1	<< "ViewFactor	Room_es::view_factor(" << s1->oid() << ", " << s2->oid() << ")\n";

				// calculate view factors
	return 1.0;
};

Surface*	Room_es::surface_for(State_variable* sv)
{
	DEBUG1	<< "Area	Room_es::surface_area(" << sv->oid() << ")\n";

	List_iterator(Surface)	surf_iter = surface_iterator();
	Surface_es*	surf;
					// cast guaranteed by Metaclass
	while(surf = (Surface_es*)surf_iter(FORWARD))
		if (surf->state_variable() == sv)
			return surf;

	return NULLPTR(Surface);
};


void		Room_es::thermal_disc()
{
	DEBUG1	<< "Room_es::thermal_disc()\n";

				// generate eqns for room  (air, etc not walls)
				//    (room contents handled separately)
	disc_conduction();
	disc_convection();
						// correct eqns for ...
	disc_longwave();		//  ...	longwave exchange
	disc_contents();		//  ...	contents (+ extra eqns)
	disc_heatsources();		//  ...	gains from people, etc
};

void	Room_es::disc_conduction()
{
	DEBUG1	<< "Room_es::disc_conduction()\n";

////		no conduction eqns for room???
};

void	Room_es::disc_convection()
{
	DEBUG1	<< "Room_es::disc_convection()\n";
				// get equtions for air volume
	airVolume()->disc_convection();
	Equation_iterator	air_eqn_iter = airVolume()->equation_iterator();
	the_equation_set = air_eqn_iter;

					// For each room surface
	List_iterator(Surface)	surf_iter = surface_iterator();
	Surface_es*	surf;
					// cast guaranteed by Metaclass
	while(surf = (Surface_es*)surf_iter(FORWARD)) {
		Equation_iterator	surf_es_iter = surf->equation_iterator();
					//    add convective coupling to airVolume
				//// if Air has more than one, how do we identify
				//// which stste var(s) to couple the surface to.
				//// Room_es has a one eqn air volume, see ctor
		convection()->add_coupling(air_eqn_iter,
					   air_eqn_iter[0]->state_variable(),
					   surf_es_iter,
					   surf_es_iter[0]->state_variable(),
					   this);
					   // area/inclination from surf =Surf_es
	};
};


void	Room_es::disc_longwave()
{
	DEBUG1	<< "Room_es::disc_longwave()\n";
					// For each room surface
	List_iterator(Surface)	surf_iter = surface_iterator();
	Surface_es*	surf;
					// cast guaranteed by Metaclass
	while(surf = (Surface_es*)surf_iter(FORWARD)) {
		Equation_iterator	surf_es_iter = surf->equation_iterator();
					//    add radiation coupling between surfs
		List_iterator(Surface)	surf2_iter = surface_iterator();
		Surface_es*	surf2;
	// process each surface pair once
		while(surf2 = (Surface_es*)surf2_iter(FORWARD))
		    if (surf2 > surf) {		// process each surface pair once
						// (nb random sequence of ptrs)
			Equation_iterator    surf2_es_iter = surf2->equation_iterator();
			radiation()->add_coupling(surf_es_iter,
						surf_es_iter[0]->state_variable(),
						surf2_es_iter,
						surf2_es_iter[0]->state_variable(),
						this);
						  // get viewfactor from this =Room
		    };
	};
};

void	Room_es::disc_contents()
{
	cout << "Room_es::disc_contents():  Not implemented\n";
	return;

////	List_iterator(Content) content_iter(theContents);
////	Content*	cnt;
////	while (cnt = content_iter(FORWARD)) {
////			// call Contents::disc_conduction();
////			// link to Room eqn_sets (air & Surf_eqns)
////			//    get air eqns & call Convection::combine_eqns()
////			//    get constr eqns & call Radiation::add_coupling()
////			//    get constr eqns & call Conduction::combine_eqns()
////	};
}

void	Room_es::disc_heatsources()
{
	DEBUG1	<< "Room_es::disc_heatsources()\n";

//// where do we get the timeperiod from (heatsource_power * timeperiod)
////	Time_of_day	timeperiod(0,0,1,0,0);	// the timestep

	Equation_iterator	air_eqn_iter = airVolume()->equation_iterator();
					//     For each heatsource
	List_iterator(HeatSource) hs_iter = heatsource_iterator();
	HeatSource* hs;
	while(hs = hs_iter(FORWARD)) {
					//         Add convective gains:
////		Energy conv_gain = hs->totalConvective*timeperiod /air_iter.size();
		Energy conv_gain = hs->convectiveOutput();
				// Room_es has a one eqn air volume, see ctor
		convection()->inject_energy(air_eqn_iter,
					    air_eqn_iter[0]->state_variable(),
					    conv_gain);
					//         Add radiant gains:
//// how do we aproportion energy between surfaces
////		Energy rad_gain = (hs.totalRadiant*timeperiod) / surf_iter.size();
		Energy rad_gain = hs->radiantOutput()/theSurfaces.size();
		List_iterator(Surface)	surf_iter = surface_iterator();
		Surface_es*	surf;
		while(surf = (Surface_es*)surf_iter(FORWARD)) {
			Equation_iterator surf_es_iter = surf->equation_iterator();
			radiation()->inject_energy(surf_es_iter,
						 surf_es_iter[0]->state_variable(),
						 rad_gain);
		};
	};
};


////List(Shortwave_beam)&	Room_es::apply_boundary_conditions(List(Shortwave_beam)& incident)
////{
/* process those shortwave beams entering this room, and return
** those leaving
** NB incident means entering room - ie leaving the surface
 */
////					// return re-transmitted beams
////	return the_shortwave->room_response(incident);
////};
