#ifndef	ROOM_DEF_H
#define	ROOM_DEF_H

#include	"infrastructure/list.h"
#include	"building/Space_def.h"
class	Volume;
class	AirVolume_def;
class	HeatSource_def;
template_declare(List,HeatSource_def);

extern	Type*	Room_def_Type_pointer;


class	Room_def : public Space_def {
protected:
	AirVolume_def*		the_volume;
	List(HeatSource_def)*	the_heatSources;

virtual	Volume	get_volume();	// overload Space::get_volume, as can calculate it
public:
	Room_def(Metaclass* meta);
	Room_def(Volume vol, AirVolume_def* airvol,
		 List(HeatSource_def)* hsourceds);
	Room_def(APL* tyeAPL);
	~Room_def();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();

	AirVolume_def*			air_volume_def();
	List_iterator(HeatSource_def)	heatSource_def_iter();

static  void    description(Metaclass* meta, ostream& s);
};


inline
Type*	Room_def::getDirectType()
{
	return TYPE_OF(Room_def);
};

#endif
