#include	"building/Room_def.h"

#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Metaclass.h"
#include	"building/AirVolume_def.h"
#include	"building/HeatSource_def.h"
template_define(List,HeatSource_def);

Type*	Room_def_Type_pointer;

	
Room_def::Room_def(Metaclass* meta)  :  (meta)
{
	DEBUG	<< "Room_def::Room_def(" << meta->oid() << ")\n";

					// name is space name ( from Space_def)
	directType(TYPE_OF(Room_def));

	the_volume = (AirVolume_def*)meta->make_def_for("AirVolume");

	cout << "How many HeatSources? ";
	int n;
	cin >> n;
	the_heatSources = new List(HeatSource_def)();
	while (n-- > 0) {
		HeatSource_def* hsd = (HeatSource_def*)meta->make_def_for("HeatSource");
		the_heatSources->append(hsd);
	};
};

Room_def::Room_def(Volume vol, AirVolume_def* airvol, List(HeatSource_def)* hsourceds)
				: Space_def(vol)
{
	DEBUG	<< "Room_def::Room_def(Volume& vol, Substance& sub)\n";

	directType(TYPE_OF(Room_def));

	the_volume = airvol;
						// deep copy
	List_iterator(HeatSource_def) iter(hsourceds);
	HeatSource_def* hsd;
	the_heatSources = new List(HeatSource_def)();
	while (hsd = iter(FORWARD)) {
		HeatSource_def* hd = new HeatSource_def(*hsd);
		the_heatSources->append(hd);
	};
};

Room_def::Room_def(APL* theAPL)  : Space_def(theAPL)
{
	RETRIEVE(the_volume);
	RETRIEVE(the_heatSources);
};

Room_def::~Room_def()
{
	DEBUG << "Room_def::~Room_def()\n";

	Destroy(FALSE);
}


void	Room_def::Destroy(Boolean aborted)
{
	DEBUG << "Room_def::Destroy(Boolean aborted)\n";

	List_iterator(HeatSource_def) iter(the_heatSources);
	HeatSource_def* hsd;
	while (hsd = iter(FORWARD)) {
		delete hsd;
	};

	DELETE(AirVolume_def, the_volume);
	DELETE(List(HeatSource_def), the_heatSources);

	if (aborted)
		Space_def::Destroy(aborted);
};


void	Room_def::putObject(Boolean deallocate)
{
	DEBUG << "Room_def::putObject(Boolean deallocate)\n";

	STORE(the_volume);
	STORE(the_heatSources);

	Space_def::putObject(deallocate);
};

void	Room_def::deleteObject(Boolean deallocate)
{
	DEBUG << "Room_def::deleteObject(Boolean deallocate)\n";

	FORGET(the_volume);
	FORGET(the_heatSources);

	Space_def::deleteObject(deallocate);
};


List_iterator(HeatSource_def)	Room_def::heatSource_def_iter()
{
	DEBUG1	<< "List_iterator(HeatSource_def)  Room_def::get_iterator()\n";

	List_iterator(HeatSource_def)	iterator(the_heatSources);
	return iterator;
};


void    Room_def::description(Metaclass* meta, ostream& s)
{
	s << "Room\n";
        s << indent << "->  AirVolume = \n";
	indent[strlen(indent)] = ' ';
        meta->describe_def_for("AirVolume", s);
	indent[strlen(indent-4)] = '\0';
	s << indent << "no heat sources: \n";
        s << indent << "->  *n HeatSource = \n";
	indent[strlen(indent)] = ' ';
        meta->describe_def_for("HeatSource", s);
	indent[strlen(indent-4)] = '\0';
};



template_implement(List,HeatSource_def);
