#ifndef ROOM_H
#define ROOM_H 

/* comment */

#include	"building/Space.h"
#include	"infrastructure/list.h"
class	Room_def;
class	AirVolume;
class	Surface;
template_declare(List,Surface);
class	HeatSource;
template_declare(List,HeatSource);


class Room : public Space {
protected:
	EKSObject*		my_caller;			// Building
	AirVolume*		theAirVolume;
	List(HeatSource)*	theHeatSources;
	List(Surface)*		theSurfaces;
public:
        Room(Metaclass* meta, Room_def* def);
	Room(APL* theAPL);
	~Room();

	void		Destroy(Boolean aborted);
	void		putObject(Boolean deallocate);
	void		deleteObject(Boolean deallocate);
	Type*		getDirectType();

	Volume				volume();
	AirVolume			airVolume();
	List_iterator(Surface)		surface_iterator();
	List_iterator(HeatSource)	heatsource_iterator();
};

#endif

