#include	"building/Room.h"

#include	<string.h>
#include	"dimensions/Volume.h"
#include	"infrastructure/Metaclass.h"
#include	"building/Room_def.h"
#include	"building/Building_basic.h"
#include	"building/Surface.h"
template_define(List,Surface);
#include	"building/HeatSource.h"
template_define(List,HeatSource);
#include	"building/HeatSource_def.h"
template_define(List,HeatSource_def);
#include	"building/AirVolume.h"
#include	"building/AirVolume_def.h"

extern	Type*	Room_Type_pointer;



Room::Room(Metaclass* meta, Room_def* def): Space(meta, (Space_def*)def)
{
	DEBUG << "Room::Room(Metaclass* meta, Room_def* def)\n";

					// name is space name ( from Space_def)
	directType(TYPE_OF(Room));

	my_caller = def->caller();

	AirVolume_def* airVolumedef = def->air_volume_def();
			  	 // tell AirVolume (via its X-def) who contains it
	airVolumedef->caller(this);
	theAirVolume = INSTANTIATE(AirVolume, airVolumedef);

	// get the Surfaces from the Room container if needed.
	theSurfaces = new List(Surface)();
	my_caller = def->caller();

	theHeatSources = new List(HeatSource)();
	List_iterator(HeatSource_def) index = def->heatSource_def_iter();
        HeatSource_def*	hs_def;
        while(hs_def=index(FORWARD)) {
		HeatSource* heatSource = INSTANTIATE(HeatSource, hs_def);
                theHeatSources->append(heatSource);
	};
};

Room::Room(APL* theAPL)  : Space(theAPL)
{
	RETRIEVE(theAirVolume);
	RETRIEVE(theHeatSources);
	RETRIEVE(theSurfaces);
};

Room::~Room()
{
	DEBUG << "Room::~Room()\n";

	Destroy(FALSE);
};


void	Room::Destroy(Boolean aborted)
{
	DEBUG << "Room::Destroy(Boolean aborted)\n";

	List_iterator(HeatSource)	hs_iter(theHeatSources);
	HeatSource* hs;
	while(hs = hs_iter(FORWARD))
		delete hs;

	DELETE(AirVolume, theAirVolume);
	DELETE(List(HeatSource), theHeatSources);
	DELETE(List(Surface), theSurfaces);

	if (aborted)
		Space::Destroy(aborted);
};

void	Room::putObject(Boolean deallocate)
{
	DEBUG << "Room::putObject(Boolean deallocate)\n";

	STORE(theAirVolume);
	STORE(theHeatSources);
	STORE(theSurfaces);

	Space::putObject(deallocate);
};

void	Room::deleteObject(Boolean deallocate)
{
	DEBUG << "Room::deleteObject(Boolean deallocate)\n";

	FORGET(theAirVolume);
	FORGET(theHeatSources);
	FORGET(theSurfaces);

	Space::deleteObject(deallocate);
};


Volume	Room::volume()
{
	DEBUG1	<< "Volume	Room::volume()\n";

			// Room volume only calculated if used
	if (theVolume == 0.0) {
		List_iterator(Surface) surf_iter = surface_iterator();
		Surface*	surf;
		while (surf = surf_iter(FORWARD))
////			theVolume += surf->polygon()->xsum();
			;
	};

	cerr << "Room::volume: Arbitarily setting volume to 8m3\n";
	theVolume = 8.0;
	return theVolume;
};


List_iterator(HeatSource)	Room::heatsource_iterator()
{
	DEBUG1	<< "List_iterator(HeatSource)  Room::get_iterator()\n";

	List_iterator(HeatSource)	iter(theHeatSources);
	return iter;
};


List_iterator(Surface)	Room::surface_iterator()
{
	DEBUG1 << "List_iterator(Surface)   Room::surface_iterator()\n";

				// local surface list created only if used.
	if (theSurfaces->size() == 0)
		*theSurfaces += ((Building_basic*)my_caller)->surfaces_for(this);
		;
	List_iterator(Surface) surf_iter(theSurfaces);
	return surf_iter;
};

template_implement(List,HeatSource);
