#ifndef	LAYER_ES_DEF_H
#define	LAYER_ES_DEF_H

#include	"dimensions/Temperature.h"
#include	"building/Layer_basic_def.h"
class	Metaclass;

extern	Type*	Layer_es_def_Type_pointer;


class Layer_es_def : public Layer_basic_def {
	int		the_no_of_divisions;
	Temperature	the_initial_temp;
	char*		the_conduction_name;
public:
	Layer_es_def(Metaclass* meta);
	Layer_es_def(Substance& sub, Length thk, int no_divs,
		     Temperature& init_temp,
		     char* a_conduction_name);
	Layer_es_def(APL* theAPL);
	~Layer_es_def();

	Type*	getDirectType();

	int		no_of_divisions();
	Temperature	initial_temp();
	char*		conduction_name();

static	void	description(Metaclass* meta, ostream& s);
};


inline
Type*	Layer_es_def::getDirectType()
{
	return TYPE_OF(Layer_es_def);
};
#endif
