#include	"building/Layer_es_def.h"

#include	<string.h>
#include	"infrastructure/Metaclass.h"
#include	"theory/Conduction_def.h"

static	char*	class_name = "the_layer_es_def";
Type*	Layer_es_def_Type_pointer;


Layer_es_def::Layer_es_def(Metaclass* meta)
					: Layer_basic_def(meta)
{
	DEBUG	<< "Layer_es_def::Layer_es_def(" << meta->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Layer_basic_def));

	cout << "Layer: how many elements (eqns) through layer depth? ";
	cin >> the_no_of_divisions;

	char	buffer[256];
	cout << "which Conduction theory object for Layer (name)? ";
	cin >> buffer;
	the_conduction_name = strdup(buffer);

	cout << "Layer: default temperature? ";
	float	temp;
	cin >> temp;
	the_initial_temp = temp;
};

Layer_es_def::Layer_es_def(Substance& sub, Length thk, int no_divs,
			   Temperature& init_temp,
			   char* a_conduction_name)
					: Layer_basic_def(sub, thk)
{
	DEBUG	<< "Layer_es_def::Layer_es_def(List(Layer_def))\n";

	name(class_name);
	directType(TYPE_OF(Layer_basic_def));

	the_no_of_divisions = no_divs;
	the_conduction_name = a_conduction_name;
	the_initial_temp = init_temp;
};

Layer_es_def::Layer_es_def(APL* theAPL) : Layer_basic_def(theAPL)
{};

Layer_es_def::~Layer_es_def()
{
	DEBUG << "Layer_es_def::~Layer_es_def()\n";
};


int	Layer_es_def::no_of_divisions()
{
	DEBUG1	<< "int	Layer_es_def::no_of_divisions()\n";

	return the_no_of_divisions;
};

Temperature	Layer_es_def::initial_temp()
{
	DEBUG1	<< "Temoerature	Layer_es_def::initial_temp()\n";

	return the_initial_temp;
};

char*	Layer_es_def::conduction_name()
{
	DEBUG1	<< "char*	Layer_es_def::conduction_name()\n";

	return the_conduction_name;
};


void	Layer_es_def::description(Metaclass* meta, ostream& s)
{
	s << "Layer_es : ";
	Layer_basic_def::description(meta, s);
	s << indent << "no of thermal divisions: \n"
	  << indent << "conduction theory name for layer: \n"
	  << indent << "initial temp: \n";
};
