#ifndef LAYER_ES_H
#define LAYER_ES_H

#include	"transport/State_vector.h"
#include	"transport/Equation_set.h"
#include	"building/Layer_basic.h"
class	Layer_es_def;
class	Conduction;

extern	Type*	Layer_es_Type_pointer;

/* A thermal layer definition for
** equation-based Conduction objects.
*/

class Layer_es : public Layer_basic {
protected:
	State_vector	the_state_vector;
	Equation_set	the_equation_set;
	int		the_no_of_divisions;
	Conduction*	the_conduction;
public:
        Layer_es(Metaclass* meta, Layer_es_def* def);
        Layer_es(Layer_es& lyr);
	Layer_es(APL* theAPL);
	~Layer_es();

	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	Type*	getDirectType();
 
	Layer_es& operator=(Layer_es& lyr);

        Conduction*		conduction();
	int			no_of_divisions();
	State_vector*		state_vector();
	Equation_iterator	equation_iterator();		// NB can be empty
        void			disc_conduction();
};


inline
Type*	Layer_es::getDirectType()
{
	return TYPE_OF(Layer_es);
};


inline
Conduction*	Layer_es::conduction()
{						// cast guaranteed by Metaclass
	return (Conduction*)the_conduction;
}

inline
Equation_iterator	Layer_es::equation_iterator()
{
	Equation_iterator	iter(&the_equation_set);
	return iter;					// list may be empty 
}

inline
State_vector*	Layer_es::state_vector()
{
	return &the_state_vector;
}

inline
int	Layer_es::no_of_divisions()
{
	return the_no_of_divisions;
}

#endif
