#include	"building/Layer_es.h"

#include	"infrastructure/Metaclass.h"
#include	"transport/State_variable.h"
#include	"transport/State_vector.h"
#include	"transport/Equation_set.h"
#include	"building/Layer_es_def.h"
#include	"theory/Conduction.h"
#include	"theory/Conduction_def.h"

static	char*	class_name = "the_layer_es_xxx";
Type*	Layer_es_Type_pointer;


Layer_es::Layer_es(Metaclass* meta, Layer_es_def* def)
				: Layer_basic(meta, (Layer_basic_def*)def),
				  the_equation_set(),
				  the_state_vector(def->no_of_divisions(), this,
					    def->initial_temp())
{
	DEBUG << "Layer_es::Layer_es(" << meta->oid() << ", " << def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Layer_es));

	the_no_of_divisions = def->no_of_divisions();
						// make a Conduction or derived
	the_conduction = (Conduction*)metaclass->link_to("Conduction",
							 def->conduction_name() );
};

Layer_es::Layer_es(Layer_es& lyr) :  Layer_basic(lyr),
				     the_equation_set(lyr.the_equation_set),
				     the_state_vector(lyr.the_state_vector)
{								// ^ shallow copy
	DEBUG << "Layer_es::Layer_es(" << lyr->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Layer_es));

	the_no_of_divisions = lyr.no_of_divisions();
	the_conduction = lyr.conduction();
};

Layer_es::Layer_es(APL* theAPL) : Layer_basic(theAPL),
				     the_equation_set(theAPL),
				     the_state_vector(theAPL)

{
	RETRIEVE(the_conduction);
}

Layer_es::~Layer_es()
{
	DEBUG << "Layer_es::~Layer_es()\n";

	Destroy(FALSE);
};


void	Layer_es::Destroy(Boolean aborted)
{
	DEBUG << "Layer_es::Destroy(Boolean aborted)\n";

	if (aborted)
		Layer_basic::Destroy(aborted);
};

void	Layer_es::putObject(Boolean deallocate)
{
	DEBUG << "Layer_es::putObject(Boolean deallocate)\n";

	STORE(the_conduction);

	Layer_basic::putObject(deallocate);
};

void	Layer_es::deleteObject(Boolean deallocate)
{
	DEBUG << "Layer_es::deleteObject(Boolean deallocate)\n";

	Layer_basic::deleteObject(deallocate);
};

 
Layer_es& Layer_es::operator=(Layer_es& lyr)
{
	DEBUG1 << "Layer_es::operator=(" << lyr->oid() << ")\n";

	if (this==&lyr) return (*this);

	(void)Layer::operator=(lyr);
	the_state_vector = lyr.the_state_vector;	// shallow copy
	the_equation_set = lyr.the_equation_set;	// shallow copy
	the_no_of_divisions = lyr.no_of_divisions();	
	the_conduction = lyr.conduction();

        return (*this);
};


void	Layer_es::disc_conduction()
{
	DEBUG1	<< "Layer_es::disc_conduction()\n";

// No need to re-evaluate time-invariant entries.
	if(the_equation_set.size() != 0)   return;

					//// modify eqns in place, so why copy???
	the_equation_set = conduction()->generate_equations (&the_state_vector,
							     this,
							     equation_iterator());
	DEBUG2	<< "got equation_set\n";
	DEBUG2	<< "Layer_es::equation_set =";
	DEBUG2	<< "\t" << the_equation_set;
};


/*
 * void Layer_es::set_state_variables(State_vector& s)
 * {
 * 	the_state_vector=s;
 * 				// zap Eqn set if necessary?
 * }
 * 
 * void Layer_es::propagate_boundary_conditions(Temperature& left,
 *					     Temperature& right)
 * {
 * 	conduction()->tidy_up(left, right);
 * }
 */
