#ifndef LAYER_BASIC_H
#define LAYER_BASIC_H

#include	"building/Layer.h"
class	Layer_basic_def;
class	ThermalResistance;
class	Diffusivity;
class	NonDimensional;
class	Time_of_day;

extern	Type*	Layer_basic_Type_pointer;

/* a thermal layer definition: a layer comprises one or more substance
which are homogeneous perpendicular to the bounding surfaces but may
vary parallel to these surfaces e.g. a masonry leaf, tiled wall*/


class Layer_basic : public Layer {
protected:
public:
	Layer_basic(Metaclass* meta, Layer_basic_def* def);
	Layer_basic(Layer_basic& lyr);
	Layer_basic(APL* theAPL);
	~Layer_basic();

	Type*	getDirectType();

	Layer_basic&	operator=(Layer_basic& lyr);

	ThermalResistance	resistance();
	Diffusivity		diffusivity();
	NonDimensional		fourier_number(Time_of_day& time_step);
};

inline
Type*	Layer_basic::getDirectType()
{
	return TYPE_OF(Layer_basic);
};
#endif


