#include	"building/Layer_basic.h"

#include	"dimensions/ThermalResistance.h"
#include	"dimensions/Diffusivity.h"
#include	"dimensions/NonDimensional.h"
#include	"infrastructure/Metaclass.h"
#include	"building/Layer_def.h"

static	char*	class_name = "the_layer_xxx";
Type*	Layer_basic_Type_pointer;
 

Layer_basic::Layer_basic(Metaclass* meta, Layer_basic_def* def)
			: Layer(meta, (Layer_def*) def)
{
	DEBUG << "Layer::Layer(" << meta->oid() << ", " << def->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Layer_basic));
};
 
Layer_basic::Layer_basic(Layer_basic& lyr) : Layer((Layer&)lyr)
{
	DEBUG << "Layer_basic::Layer_basic(" << lyr->oid() << ")\n";

	name(class_name);
	directType(TYPE_OF(Layer_basic));
}

Layer_basic::Layer_basic(APL* theAPL) : Layer(theAPL)
{}

Layer_basic::~Layer_basic()
{
	DEBUG << "Layer_basic::~Layer_basic()\n";
};

 
Layer_basic& Layer_basic::operator=(Layer_basic& lyr)
{
	DEBUG1 << "Layer_basic::operator=(" << lyr->oid() << ")\n";

	if (this==&lyr) return (*this);

	(void) Layer::operator=((Layer&)lyr);

        return (*this);
};


ThermalResistance	Layer_basic::resistance()
{
	DEBUG1 << "ThermalResistance  Layer_basic::resistance()\n";

	return ThermalResistance(theThickness/
				      theSubstance.thermalConductivity());
};

Diffusivity	Layer_basic::diffusivity()
{
	DEBUG1 << "Diffusivity  Layer_basic::diffusivity()\n";

	return Diffusivity(theThickness/
				      theSubstance.thermalConductivity());
};

NonDimensional	Layer_basic::fourier_number(Time_of_day& time_step)
{
	DEBUG1 << "NonDimensional  Layer_basic::fourier_number(Time_of_day&)\n";

	return NonDimensional(theSubstance.thermalConductivity()/
		theSubstance.density() * theSubstance.specificHeatCapacity());
};
