#ifndef	HEATSOURCE_DEF_H
#define	HEATSOURCE_DEF_H

#include	"dimensions/Power.h"
#include	"dimensions/Proportion.h"
#include	"context/X_def.h"

extern	Type*	HeatSource_def_Type_pointer;


class	HeatSource_def : public X_def {
	Power		the_output;
	Proportion	the_rad_conv_split;
public:
	HeatSource_def(Metaclass* meta);
	HeatSource_def(Power& output, Proportion& split);
	HeatSource_def(APL* theAPL);
	~HeatSource_def();

	Type*	getDirectType();

	Power		power();
	Proportion	rad_conv_split();

static  void    description(Metaclass* meta, ostream& s);
};


inline
Type*	HeatSource_def::getDirectType()
{
	return TYPE_OF(HeatSource_def);
};


inline
Power	HeatSource_def::power()
{
	return the_output;
};

inline
Proportion	HeatSource_def::rad_conv_split()
{
	return the_rad_conv_split;
};

#endif
